/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import com.mulesoft.mq.restclient.client.mq.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessageBuilder;
import com.mulesoft.mq.restclient.client.mq.domain.DefaultMessageIdResult;
import com.mulesoft.mq.restclient.client.mq.domain.FallbackConfigResult;
import com.mulesoft.mq.restclient.client.mq.domain.Lock;
import com.mulesoft.mq.restclient.client.mq.domain.MessageIdResult;
import com.mulesoft.mq.restclient.internal.CourierObservable;
import com.mulesoft.mq.restclient.internal.Destination;
import com.mulesoft.mq.restclient.internal.impl.DefaultCourierObservable;
import com.mulesoft.mq.restclient.internal.impl.LockedMessage;
import com.mulesoft.mq.restclient.internal.impl.TimeSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import rx.Observable;

public class TestDestination
implements Destination {
    private static final String DEFAULT_NAME = "Test Destination";
    private final Queue<AnypointMQMessage> queue = new LinkedList<AnypointMQMessage>();
    private final TimeSupplier timeSupplier;
    private int receiveCount;
    private long lastReceiveTime;
    private int modifyLockIntervalCount;
    private Map<String, Integer> modifyLockIntervalCountPerMessage;
    private ExecutorService executorService;

    public TestDestination(TimeSupplier timeSupplier) {
        this(DEFAULT_NAME, timeSupplier);
    }

    public TestDestination(String name, TimeSupplier timeSupplier) {
        this.timeSupplier = timeSupplier;
        this.lastReceiveTime = -1L;
        this.modifyLockIntervalCountPerMessage = new HashMap<String, Integer>();
        this.executorService = Executors.newScheduledThreadPool(4);
    }

    public int getReceiveCount() {
        return this.receiveCount;
    }

    public long getLastReceiveTime() {
        return this.lastReceiveTime;
    }

    public int getModifyLockIntervalCount() {
        return this.modifyLockIntervalCount;
    }

    public int getModifyLockIntervalCount(String messageId) {
        Integer count = this.modifyLockIntervalCountPerMessage.get(messageId);
        return count != null ? count : 0;
    }

    public String getName() {
        return DEFAULT_NAME;
    }

    public String getName(boolean getFallbackName) {
        return this.getName();
    }

    public Destination.FallbackConfiguration getFallbackConfiguration() {
        return Destination.FallbackConfiguration.NOT_CONFIGURED;
    }

    public void setFallbackConfiguration(Destination.FallbackConfiguration newFallbackConfiguration) {
    }

    public boolean getPrimaryRegionDown() {
        return false;
    }

    public void setPrimaryRegionDown(boolean primaryRegionDown) {
    }

    public long getPrimaryRegionStatusLastChecked() {
        return 0L;
    }

    public void setPrimaryRegionStatusLastChecked(long primaryRegionStatusLastChecked) {
    }

    public boolean getFallbackHasMessages() {
        return false;
    }

    public void setFallbackHasMessages(boolean fallbackHasMessages) {
    }

    public long getFallbackMessagesLastChecked() {
        return 0L;
    }

    public void setFallbackMessagesLastChecked(long fallbackMessagesLastChecked) {
    }

    public CourierObservable<FallbackConfigResult> fetchFallbackConfiguration(boolean useFallbackDestination, int retryCount) {
        return null;
    }

    public CourierObservable<MessageIdResult> send(AnypointMQMessage message, boolean useFallbackDestination, int retryCount) {
        return new DefaultCourierObservable((Object)this.addToQueue(message));
    }

    private MessageIdResult addToQueue(AnypointMQMessage message) {
        return this.queue.offer(message) ? this.createSuccessfulMessageIdResult(message) : this.createErrorlMessageIdResult(message);
    }

    public CourierObservable<List<MessageIdResult>> send(List<AnypointMQMessage> messages, boolean useFallbackDestination, int retryCount) {
        ArrayList<MessageIdResult> results = new ArrayList<MessageIdResult>();
        for (AnypointMQMessage message : messages) {
            results.add(this.addToQueue(message));
        }
        return new DefaultCourierObservable(results);
    }

    public CourierObservable<List<AnypointMQMessage>> receive() {
        return this.receive(1, 0L, 0L, false, false, AbstractCourierRestClient.MAX_RETRIES);
    }

    public CourierObservable<List<AnypointMQMessage>> receive(int batchSize, long pollingTime, long lockTtl, boolean useFallbackDestination, boolean shortPolling, int retryCount) {
        Observable objectObservable = Observable.create(subscriber -> this.executorService.submit(() -> {
            ArrayList<AnypointMQMessage> result = new ArrayList<AnypointMQMessage>();
            if (!this.queue.isEmpty()) {
                for (int i = 0; i < batchSize && !this.queue.isEmpty(); ++i) {
                    result.add(this.queue.poll());
                }
            } else {
                try {
                    Thread.sleep(pollingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this.receiveCount;
            this.lastReceiveTime = this.timeSupplier.get();
            subscriber.onNext(result);
            subscriber.onCompleted();
        }));
        return new DefaultCourierObservable(objectObservable);
    }

    public CourierObservable<List<MessageIdResult>> ack(List<Lock> locks, boolean usedFallbackDestination) {
        return this.createSuccessResultsWithLocks(locks);
    }

    public CourierObservable<MessageIdResult> ack(Lock lock, boolean usedFallbackDestination) {
        return this.createSuccessResultsWithLock(lock);
    }

    public CourierObservable<List<MessageIdResult>> nack(List<Lock> locks, boolean usedFallbackDestination) {
        return this.createSuccessResultsWithLocks(locks);
    }

    public CourierObservable<MessageIdResult> nack(Lock lock, boolean usedFallbackDestination) {
        return this.createSuccessResultsWithLock(lock);
    }

    public CourierObservable<List<MessageIdResult>> modifyLockInterval(List<AnypointMQMessage> messages, int lockInterval, boolean usedFallbackDestination) {
        ++this.modifyLockIntervalCount;
        for (AnypointMQMessage message : messages) {
            Integer count = this.modifyLockIntervalCountPerMessage.get(message.getMessageId());
            count = count == null ? 1 : count + 1;
            this.modifyLockIntervalCountPerMessage.put(message.getMessageId(), count);
        }
        return this.createSuccessResults(messages);
    }

    public CourierObservable<List<MessageIdResult>> modifyLockInterval(List<LockedMessage> lockedMessages, boolean usedFallbackDestination) {
        ++this.modifyLockIntervalCount;
        ArrayList<AnypointMQMessage> messages = new ArrayList<AnypointMQMessage>();
        for (LockedMessage lockedMessage : lockedMessages) {
            Integer count = this.modifyLockIntervalCountPerMessage.get(lockedMessage.getMessage().getMessageId());
            count = count == null ? 1 : count + 1;
            this.modifyLockIntervalCountPerMessage.put(lockedMessage.getMessage().getMessageId(), count);
            messages.add(lockedMessage.getMessage());
        }
        return this.createSuccessResults(messages);
    }

    public AnypointMQMessageBuilder newMessageBuilder() {
        return null;
    }

    private CourierObservable<List<MessageIdResult>> createSuccessResults(List<AnypointMQMessage> messages) {
        List results = messages.stream().map(this::createSuccessfulMessageIdResult).collect(Collectors.toList());
        return new DefaultCourierObservable(results);
    }

    private CourierObservable<List<MessageIdResult>> createSuccessResultsWithLocks(List<Lock> locks) {
        List results = locks.stream().map(this::createSuccessfulMessageIdResult).collect(Collectors.toList());
        return new DefaultCourierObservable(results);
    }

    private CourierObservable<MessageIdResult> createSuccessResults(AnypointMQMessage message) {
        return new DefaultCourierObservable((Object)this.createSuccessfulMessageIdResult(message));
    }

    private CourierObservable<MessageIdResult> createSuccessResultsWithLock(Lock lock) {
        return new DefaultCourierObservable((Object)this.createSuccessfulMessageIdResult(lock));
    }

    private MessageIdResult createSuccessfulMessageIdResult(AnypointMQMessage message) {
        return new DefaultMessageIdResult(message.getMessageId(), "successful", "");
    }

    private MessageIdResult createSuccessfulMessageIdResult(Lock lock) {
        return new DefaultMessageIdResult(lock.getMessageId(), "successful", "");
    }

    private MessageIdResult createErrorlMessageIdResult(AnypointMQMessage message) {
        return new DefaultMessageIdResult(message.getMessageId(), "ERROR", "");
    }
}

