/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FallbackSystemProperties {
    private static Boolean crossRegionFailoverFeatureEnabled = null;
    private static Boolean mockPrimaryRegionFailureMunit = null;
    private static Integer primaryRegionStatusCheckIntervalMs = null;
    private static Integer fallbackMessagesCheckIntervalMs = null;
    public static final String CROSS_REGION_FAILOVER_FEATURE_ENABLED_PROPERTY_NAME = "cross.region.failover.feature.enabled";
    private static final boolean CROSS_REGION_FAILOVER_FEATURE_ENABLED_DEFAULT = false;
    public static final String MOCK_PRIMARY_REGION_FAILURE_MUNIT = "mock.primary.region.failure.munit";
    private static final boolean MOCK_PRIMARY_REGION_FAILURE_MUNIT_DEFAULT = false;
    public static final String PRIMARY_REGION_STATUS_CHECK_INTERVAL_PROPERTY_NAME = "primary.region.status.check.interval.ms";
    private static final int PRIMARY_REGION_STATUS_CHECK_INTERVAL_DEFAULT = 60000;
    private static final int PRIMARY_REGION_STATUS_CHECK_INTERVAL_LOWEST = 60000;
    private static final int PRIMARY_REGION_STATUS_CHECK_INTERVAL_HIGHEST = 900000;
    public static final String FALLBACK_MESSAGES_CHECK_INTERVAL_PROPERTY_NAME = "fallback.messages.check.interval.ms";
    private static final int FALLBACK_MESSAGES_CHECK_INTERVAL_DEFAULT = 300000;
    private static final int FALLBACK_MESSAGES_CHECK_INTERVAL_LOWEST = 60000;
    private static final int FALLBACK_MESSAGES_CHECK_INTERVAL_HIGHEST = 43200000;
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackSystemProperties.class);

    private FallbackSystemProperties() {
    }

    private static int fetchNumericSystemProperty(String propertyName, int defaultValue, int lowest, int highest) {
        int propertyValue = defaultValue;
        try {
            propertyValue = Integer.parseInt(System.getProperty(propertyName, String.valueOf(defaultValue)));
            if (propertyValue < lowest || propertyValue > highest) {
                LOGGER.warn(String.format("%s = %s is not within the valid range [%s, %s], will use the default value %s instead.", propertyName, propertyValue, lowest, highest, defaultValue));
                propertyValue = defaultValue;
            }
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Error occurred while trying to fetch property %s, using default value %s instead. Error: %s", propertyName, defaultValue, e.getMessage()));
        }
        return propertyValue;
    }

    private static boolean fetchBooleanSystemProperty(String propertyName, boolean defaultValue) {
        boolean propertyValue = defaultValue;
        try {
            String systemPropValue = System.getProperty(propertyName, String.valueOf(defaultValue)).toLowerCase();
            if (!systemPropValue.equals("true") && !systemPropValue.equals("false")) {
                LOGGER.warn(String.format("%s = %s is not a valid boolean value, will use the default value %s instead.", propertyName, systemPropValue, defaultValue));
            } else {
                propertyValue = Boolean.parseBoolean(systemPropValue);
            }
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Error occurred while trying to fetch property %s, using default value %s instead. Error: %s", propertyName, defaultValue, e.getMessage()));
        }
        return propertyValue;
    }

    public static synchronized int getPrimaryRegionStatusCheckIntervalMs() {
        if (primaryRegionStatusCheckIntervalMs == null) {
            primaryRegionStatusCheckIntervalMs = FallbackSystemProperties.fetchNumericSystemProperty(PRIMARY_REGION_STATUS_CHECK_INTERVAL_PROPERTY_NAME, 60000, 60000, 900000);
        }
        return primaryRegionStatusCheckIntervalMs;
    }

    public static synchronized int getFallbackMessagesCheckIntervalMs() {
        if (fallbackMessagesCheckIntervalMs == null) {
            fallbackMessagesCheckIntervalMs = FallbackSystemProperties.fetchNumericSystemProperty(FALLBACK_MESSAGES_CHECK_INTERVAL_PROPERTY_NAME, 300000, 60000, 43200000);
        }
        return fallbackMessagesCheckIntervalMs;
    }

    public static synchronized boolean getCrossRegionFailoverFeatureEnabled() {
        crossRegionFailoverFeatureEnabled = FallbackSystemProperties.fetchBooleanSystemProperty(CROSS_REGION_FAILOVER_FEATURE_ENABLED_PROPERTY_NAME, false);
        return crossRegionFailoverFeatureEnabled;
    }

    public static synchronized boolean getMockPrimaryRegionFailureMunit() {
        mockPrimaryRegionFailureMunit = FallbackSystemProperties.fetchBooleanSystemProperty(MOCK_PRIMARY_REGION_FAILURE_MUNIT, false);
        return mockPrimaryRegionFailureMunit;
    }
}

