/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.client.mq;

import com.google.gson.reflect.TypeToken;
import com.mulesoft.mq.restclient.client.Request;
import com.mulesoft.mq.restclient.client.RequestBuilder;
import com.mulesoft.mq.restclient.client.Response;
import com.mulesoft.mq.restclient.client.authenticationserver.AuthenticationServerUrlBuilder;
import com.mulesoft.mq.restclient.client.authenticationserver.domain.ApiMeResponse;
import com.mulesoft.mq.restclient.client.authenticationserver.domain.OauthTokenResponse;
import com.mulesoft.mq.restclient.client.mq.CourierRestClient;
import com.mulesoft.mq.restclient.client.mq.CourierUrlBuilder;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQReceiveBatchResponse;
import com.mulesoft.mq.restclient.client.mq.domain.DefaultFallbackConfigResult;
import com.mulesoft.mq.restclient.client.mq.domain.DefaultMessageIdResult;
import com.mulesoft.mq.restclient.client.mq.domain.FallbackConfigResult;
import com.mulesoft.mq.restclient.client.mq.domain.Lock;
import com.mulesoft.mq.restclient.client.mq.domain.MessageIdResult;
import com.mulesoft.mq.restclient.client.mq.domain.NewTtl;
import com.mulesoft.mq.restclient.client.mq.domain.OAuthCredentials;
import com.mulesoft.mq.restclient.client.mq.domain.ServiceRegistryResponse;
import com.mulesoft.mq.restclient.exception.ExceptionFactory;
import com.mulesoft.mq.restclient.exception.MQClientConnectionException;
import com.mulesoft.mq.restclient.internal.DestinationLocation;
import com.mulesoft.mq.restclient.internal.impl.DestinationLocationBuilder;
import com.mulesoft.mq.restclient.utils.ClientUtils;
import com.mulesoft.mq.restclient.utils.FallbackSystemProperties;
import com.mulesoft.mq.restclient.utils.JsonUtils;
import com.mulesoft.mq.restclient.utils.MessageUtils;
import com.mulesoft.mq.restclient.utils.UrlConversionUtils;
import java.lang.reflect.Type;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.backoff.BackOffExecution;
import org.springframework.util.backoff.ExponentialBackOff;
import rx.Observable;
import rx.functions.Func1;
import rx.observables.BlockingObservable;
import rx.schedulers.Schedulers;

public abstract class AbstractCourierRestClient
implements CourierRestClient {
    public static final String BATCH_SIZE_QUERY_PARAM = "batchSize";
    public static final String POOLING_TIME_QUERY_PARAM = "pollingTime";
    public static final String LOCK_TTL_QUERY_PARAM = "lockTtl";
    public static final long DEFAULT_TIMEOUT_MILLIS = 20000L;
    public static final int MAX_RETRIES = Integer.getInteger("max.retries.failure.operation", 5);
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractCourierRestClient.class);
    protected static final int EXTRA_RECEIVE_TIMEOUT = 2000;
    private static final String ORGANIZATIONS = "organizations";
    private static final String ENVIRONMENTS = "environments";
    private static final String AUTHENTICATION_TOKEN_TYPE = "Bearer ";
    private static final long BACK_OFF_MULTIPLIER = Long.parseLong(System.getProperty("object.store.client.back.off.multiplier", "2"));
    private static final long BACK_OFF_INITIAL_WAIT = Long.parseLong(System.getProperty("object.store.client.back.off.initial.wait", "1000"));
    private static final long BACK_OFF_MAX_INTERVAL = Long.parseLong(System.getProperty("object.store.client.back.off.max.interval", "30000"));
    private static final List<AnypointMQMessage> EMPTY_MESSAGES_LIST = Collections.emptyList();
    private static final int MAX_GET_ACCESS_TOKEN_RETRIES = 5;
    private static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    private static final int HTTP_TOO_MANY_REQUESTS = 429;
    private static final int HTTP_MAX_ERROR_CODE = 599;
    private static final Type MESSAGES_LIST_TYPE = new TypeToken<List<AnypointMQReceiveBatchResponse>>(){}.getType();
    private static final Type FALLBACK_CONFIG_RESULT_TYPE = new TypeToken<DefaultFallbackConfigResult>(){}.getType();
    private static final Type MESSAGE_ID_RESULT_TYPE = new TypeToken<DefaultMessageIdResult>(){}.getType();
    private static final Type MESSAGE_IDS_RESULT_TYPE = new TypeToken<List<DefaultMessageIdResult>>(){}.getType();
    private static final Type SERVICE_REGISTRY_TYPE = new TypeToken<ServiceRegistryResponse>(){}.getType();
    private static final Type OAUTH2_TOKEN_TYPE = new TypeToken<OauthTokenResponse>(){}.getType();
    private static final Type API_ME_TYPE = new TypeToken<ApiMeResponse>(){}.getType();
    private final OAuthCredentials oAuthCredentials;
    private final String userAgentInfo;
    private final CourierUrlBuilder courierUrlBuilder;
    private AuthenticationServerUrlBuilder authenticationServerUrlBuilder;
    private BlockingObservable<Response> observableAccessTokenResponse;
    private String accessToken;
    private final String inputApiUrl;
    private String defaultOrganizationId;
    private String defaultEnvironmentId;
    private boolean useV2Oauth2TokenEndpoint = false;
    private boolean alreadyDisposed = false;
    private Random rand;
    private static final String REGEX_PATTERN = "^https?:\\/\\/[a-zA-Z0-9:.-]*\\/api\\/v1\\/organizations\\/[a-zA-Z0-9-]*\\/environments\\/[a-zA-Z0-9-]*";
    private final boolean isCrossRegionFailoverFeatureEnabled = FallbackSystemProperties.getCrossRegionFailoverFeatureEnabled();

    public AbstractCourierRestClient(String courierApiUrl, OAuthCredentials oAuthCredentials, String userAgentInfo) throws IllegalArgumentException {
        this.inputApiUrl = courierApiUrl;
        this.courierUrlBuilder = this.validateAndSetCourierURL();
        this.oAuthCredentials = oAuthCredentials;
        this.userAgentInfo = userAgentInfo == null || userAgentInfo.trim().isEmpty() ? ClientUtils.getUserAgent() : userAgentInfo;
        this.rand = new SecureRandom();
    }

    @Override
    public void init() {
        this.getServiceRegistry();
        this.ensureAccessToken();
        this.getClientInformation();
    }

    @Override
    public void validate() {
        if (!((Response)this.process(this.createOauthRequest()).toBlocking().first()).isOk()) {
            throw new MQClientConnectionException("Connection is not valid");
        }
    }

    @Override
    public void dispose() {
        LOGGER.debug("Client Disposed");
        this.alreadyDisposed = true;
    }

    @Override
    public DestinationLocation getDestinationLocation(String destinationName) {
        ClientUtils.checkArgument(destinationName != null && !destinationName.trim().isEmpty(), "destinationName cannot be null nor empty");
        return new DestinationLocationBuilder().setOrganizationId(this.getDefaultOrganizationId()).setEnvironmentId(this.getDefaultEnvironmentId()).setName(destinationName).build();
    }

    public String getDefaultOrganizationId() {
        return this.defaultOrganizationId;
    }

    public String getDefaultEnvironmentId() {
        return this.defaultEnvironmentId;
    }

    protected void ensureAccessToken() {
        if (this.accessToken == null) {
            this.useV2Oauth2TokenEndpoint = false;
            this.getAccessToken();
        }
    }

    protected String getBaseUri() {
        return this.courierUrlBuilder.getBaseUri();
    }

    @Override
    public Observable<List<AnypointMQMessage>> receive(DestinationLocation destinationLocation, int batchSize, long pollingTime, long lockTtl, boolean useFallbackDestination, boolean shortPolling, int retryCount) {
        RequestBuilder requestBuilder = this.newRequestBuilderWithAgent().use(RequestBuilder.Method.GET).to(this.courierUrlBuilder.messages(destinationLocation, useFallbackDestination));
        if (batchSize > 1) {
            requestBuilder.withQueryParam(BATCH_SIZE_QUERY_PARAM, Integer.toString(batchSize));
        }
        if (pollingTime > 0L || shortPolling) {
            requestBuilder.withQueryParam(POOLING_TIME_QUERY_PARAM, Long.toString(shortPolling ? 0L : pollingTime));
            requestBuilder.waitingUpTo(pollingTime + 2000L, TimeUnit.MILLISECONDS);
        }
        if (lockTtl > 0L) {
            requestBuilder.withQueryParam(LOCK_TTL_QUERY_PARAM, Long.toString(lockTtl));
        }
        return this.withAccessToken(() -> this.processWithCustomRetryCount(requestBuilder.withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.accessToken).build(), retryCount).flatMap(response -> {
            try {
                if (response.getStatusCode() == 204) {
                    return Observable.just(EMPTY_MESSAGES_LIST);
                }
                if (response.isOk()) {
                    String body = response.getBody();
                    return Observable.just(this.courierRestMessagesFromJson(body));
                }
                return Observable.error((Throwable)ExceptionFactory.create("RECEIVE MESSAGES", response, this.friendlyMessage((Response)response)));
            }
            catch (Exception e) {
                return Observable.error((Throwable)ExceptionFactory.create("RECEIVE MESSAGES", e));
            }
        }));
    }

    @Override
    public Observable<FallbackConfigResult> getFallbackConfig(DestinationLocation destinationLocation, boolean useFallbackDestination, int retryCount) {
        return this.withAccessToken(() -> this.oneResultFallbackConfig("GET FALLBACK CONFIG", this.processWithCustomRetryCount(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.GET).to(this.courierUrlBuilder.fallbackConfig(destinationLocation, useFallbackDestination)).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.accessToken).build(), retryCount)));
    }

    @Override
    public Observable<MessageIdResult> send(DestinationLocation destinationLocation, AnypointMQMessage message, boolean useFallbackDestination, int retryCount) {
        return this.withAccessToken(() -> this.oneResult("SEND ONE MESSAGE", this.processWithCustomRetryCount(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.PUT).to(this.courierUrlBuilder.message(destinationLocation, message.getMessageId(), useFallbackDestination)).withBody(JsonUtils.toJson(message)).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.accessToken).build(), retryCount)));
    }

    @Override
    public Observable<List<MessageIdResult>> send(DestinationLocation destinationLocation, List<AnypointMQMessage> messages, boolean useFallbackDestination, int retryCount) {
        return this.withAccessToken(() -> this.manyResults("SEND MANY MESSAGES", this.processWithCustomRetryCount(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.PUT).to(this.courierUrlBuilder.messages(destinationLocation, useFallbackDestination)).withBody(JsonUtils.toJson(messages)).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.accessToken).build(), retryCount)));
    }

    @Override
    public Observable<MessageIdResult> ack(DestinationLocation destinationLocation, Lock lock, boolean usedFallbackDestination) {
        return this.withAccessToken(() -> this.oneResult("ACK ONE MESSAGE", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.DELETE).to(this.courierUrlBuilder.message(destinationLocation, lock.getMessageId(), usedFallbackDestination)).withBody(JsonUtils.toJson("lockId", lock.getLockId())).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.accessToken).build())));
    }

    @Override
    public Observable<List<MessageIdResult>> ack(DestinationLocation destinationLocation, List<Lock> locks, boolean usedFallbackDestination) {
        return this.withAccessToken(() -> this.manyResults("ACK MANY MESSAGES", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.DELETE).to(this.courierUrlBuilder.messages(destinationLocation, usedFallbackDestination)).withBody(JsonUtils.toJson(locks)).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.accessToken).build())));
    }

    @Override
    public Observable<MessageIdResult> nack(DestinationLocation destinationLocation, Lock lock, boolean usedFallbackDestination) {
        return this.withAccessToken(() -> this.oneResult("NOT-ACK ONE MESSAGE", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.DELETE).to(this.courierUrlBuilder.lock(destinationLocation, lock.getMessageId(), lock.getLockId(), usedFallbackDestination)).withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.accessToken).build())));
    }

    @Override
    public Observable<List<MessageIdResult>> nack(DestinationLocation destinationLocation, List<Lock> locks, boolean usedFallbackDestination) {
        return this.withAccessToken(() -> this.manyResults("NOT-ACK MANY MESSAGES", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.DELETE).to(this.courierUrlBuilder.locks(destinationLocation, usedFallbackDestination)).withBody(JsonUtils.toJson(locks)).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.accessToken).build())));
    }

    @Override
    public Observable<MessageIdResult> modifyTtl(DestinationLocation destinationLocation, NewTtl newTtl, boolean usedFallbackDestination) {
        return this.withAccessToken(() -> this.oneResult("MODIFY TTL ONE MESSAGE", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.PATCH).to(this.courierUrlBuilder.lock(destinationLocation, newTtl.getMessageId(), newTtl.getLockId(), usedFallbackDestination)).withBody(JsonUtils.toJson("ttl", Long.toString(newTtl.getTtl()))).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.accessToken).build())));
    }

    @Override
    public Observable<List<MessageIdResult>> modifyTtl(DestinationLocation destinationLocation, List<NewTtl> newTtls, boolean usedFallbackDestination) {
        return this.withAccessToken(() -> this.manyResults("MODIFY TTL MANY MESSAGES", this.processWithRetry(this.newRequestBuilderWithAgent().use(RequestBuilder.Method.PATCH).to(this.courierUrlBuilder.locks(destinationLocation, usedFallbackDestination)).withBody(JsonUtils.toJson(newTtls)).withHeader("Content-Type", "application/json").withHeader("Authorization", AUTHENTICATION_TOKEN_TYPE + this.accessToken).build())));
    }

    public CourierUrlBuilder validateAndSetCourierURL() throws IllegalArgumentException {
        String baseUrl = this.obtainBaseURL(this.inputApiUrl);
        String fallbackApiUrl = UrlConversionUtils.getFallbackRegionUrl(baseUrl);
        if (fallbackApiUrl != null) {
            return new CourierUrlBuilder(baseUrl, fallbackApiUrl);
        }
        return new CourierUrlBuilder(baseUrl);
    }

    public String obtainBaseURL(String inputUrl) throws IllegalArgumentException {
        if (!this.validateInputURL(inputUrl)) {
            throw new IllegalArgumentException("Invalid api url provided " + inputUrl);
        }
        int index = inputUrl.indexOf("/organizations");
        return inputUrl.substring(0, index);
    }

    public boolean validateInputURL(String inputUrl) {
        Pattern r = Pattern.compile(REGEX_PATTERN);
        Matcher m = r.matcher(inputUrl);
        return m.find();
    }

    private <T> Observable<T> withAccessToken(Supplier<Observable<T>> requestExecutor) {
        try {
            this.getAccessToken();
        }
        catch (Exception e) {
            return Observable.error((Throwable)e);
        }
        return requestExecutor.get();
    }

    private synchronized void resetAccessToken() {
        if (this.accessToken == null && this.observableAccessTokenResponse != null) {
            return;
        }
        this.accessToken = null;
        this.observableAccessTokenResponse = this.process(this.createOauthRequest()).toBlocking();
    }

    private Request createServiceRegistryRequest(boolean useFallbackRegion) {
        String url = this.courierUrlBuilder.serviceRegistryUrl(useFallbackRegion);
        if (url == null) {
            return null;
        }
        return this.newRequestBuilderWithAgent().use(RequestBuilder.Method.GET).to(url).build();
    }

    private Request createOauthRequest() {
        return this.newRequestBuilderWithAgent().use(RequestBuilder.Method.POST).to(this.useV2Oauth2TokenEndpoint ? this.authenticationServerUrlBuilder.connAppOauth2TokenUrl() : this.authenticationServerUrlBuilder.oauth2TokenUrl()).withHeader("Content-Type", "application/x-www-form-urlencoded").withBody("client_id=" + this.oAuthCredentials.getClientId() + "&client_secret=" + this.oAuthCredentials.getClientSecret() + "&grant_type=client_credentials").build();
    }

    private void getServiceRegistry() {
        Request serviceRegistryRequest;
        try {
            Response response = (Response)this.processWithRetry(this.createServiceRegistryRequest(false)).toBlocking().first();
            if (response != null && response.isOk()) {
                ServiceRegistryResponse serviceRegistryResponse = (ServiceRegistryResponse)JsonUtils.fromJson(response.getBody(), SERVICE_REGISTRY_TYPE);
                this.authenticationServerUrlBuilder = new AuthenticationServerUrlBuilder(serviceRegistryResponse.getAuthenticationServer().getUrl());
                return;
            }
        }
        catch (Exception response) {
            // empty catch block
        }
        if (this.isCrossRegionFailoverFeatureEnabled && (serviceRegistryRequest = this.createServiceRegistryRequest(true)) != null) {
            LOGGER.warn("Primary region is down, trying to fetch authentication url from fallback region");
            Response fallbackResponse = (Response)this.processWithRetry(serviceRegistryRequest).toBlocking().first();
            if (fallbackResponse != null && fallbackResponse.isOk()) {
                ServiceRegistryResponse serviceRegistryResponse = (ServiceRegistryResponse)JsonUtils.fromJson(fallbackResponse.getBody(), SERVICE_REGISTRY_TYPE);
                this.authenticationServerUrlBuilder = new AuthenticationServerUrlBuilder(serviceRegistryResponse.getAuthenticationServer().getUrl());
                return;
            }
        }
        this.getFriendlyErrorMessage("Can not get url from service registry " + this.courierUrlBuilder.serviceRegistryUrl(), "GET SERVICE REGISTRY AGAINST BROKER", null);
    }

    private void getClientInformation() {
        if (!this.validateInputURL(this.inputApiUrl)) {
            this.getFriendlyErrorMessage("Can not get org and env information from " + this.inputApiUrl, "GET CLIENT INFORMATION FROM API URL", null);
        }
        int index = this.inputApiUrl.indexOf("/organizations");
        String urlParams = this.inputApiUrl.substring(index + 1);
        String[] tokens = urlParams.split("/");
        int orgTokenIndex = 0;
        int envTokenIndex = 2;
        if (tokens[orgTokenIndex].equals(ORGANIZATIONS) && tokens[envTokenIndex].equals(ENVIRONMENTS)) {
            this.defaultOrganizationId = tokens[orgTokenIndex + 1];
            this.defaultEnvironmentId = tokens[envTokenIndex + 1];
        } else {
            this.getFriendlyErrorMessage("Can not get org and env information from " + this.inputApiUrl, "GET CLIENT INFORMATION FROM API URL", null);
        }
    }

    private void getFriendlyErrorMessage(String errorMessage, String operation, Response response) {
        String responseMessage;
        StringBuilder friendlyMessage = new StringBuilder(errorMessage);
        if (response != null && !(responseMessage = this.friendlyMessage(response)).trim().isEmpty()) {
            friendlyMessage.append(" - ").append(responseMessage);
        }
        throw ExceptionFactory.create(operation, response, friendlyMessage.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken() {
        if (this.accessToken != null) {
            return this.accessToken;
        }
        Response accessTokenResponse = null;
        Exception lastException = null;
        AbstractCourierRestClient abstractCourierRestClient = this;
        synchronized (abstractCourierRestClient) {
            if (this.accessToken == null) {
                if (this.observableAccessTokenResponse == null) {
                    this.resetAccessToken();
                }
                for (int accessTokenRetries = 0; this.accessToken == null && accessTokenRetries < 5; ++accessTokenRetries) {
                    accessTokenResponse = null;
                    try {
                        accessTokenResponse = (Response)this.observableAccessTokenResponse.first();
                    }
                    catch (Exception e) {
                        lastException = e;
                    }
                    if (accessTokenResponse != null && accessTokenResponse.isOk()) {
                        OauthTokenResponse oauthTokenResponse = (OauthTokenResponse)JsonUtils.fromJson(accessTokenResponse.getBody(), OAUTH2_TOKEN_TYPE);
                        this.accessToken = oauthTokenResponse.getAccessToken();
                        continue;
                    }
                    if (accessTokenResponse == null || accessTokenResponse.getStatusCode() != 422) continue;
                    this.useV2Oauth2TokenEndpoint = true;
                    this.observableAccessTokenResponse = null;
                    this.resetAccessToken();
                }
            }
        }
        if (this.accessToken == null) {
            this.throwGetAccessTokenError(accessTokenResponse, lastException);
        }
        return this.accessToken;
    }

    private void throwGetAccessTokenError(Response accessTokenResponse, Exception lastException) {
        String logError = "Can not login into Authentication Server ";
        logError = this.useV2Oauth2TokenEndpoint ? logError + this.authenticationServerUrlBuilder.connAppOauth2TokenUrl() : logError + this.authenticationServerUrlBuilder.oauth2TokenUrl();
        StringBuilder sb = new StringBuilder(logError);
        String response = this.friendlyMessage(accessTokenResponse);
        if (!response.trim().isEmpty()) {
            sb.append(" - ").append(response);
        }
        if (lastException != null) {
            sb.append(" - ").append(lastException.getMessage());
        }
        LOGGER.debug(sb.toString());
        throw ExceptionFactory.create("AUTHORIZE AGAINST AUTH SERVER", accessTokenResponse, sb.toString(), lastException);
    }

    private String friendlyMessage(Response response) {
        if (response != null) {
            if (response.getStatusCode() == 401) {
                return "NOT AUTHORISED";
            }
            if (response.getStatusCode() == 422) {
                return "CONNECTED APP CLIENT-ID " + this.oAuthCredentials.getClientId() + " COULD NOT BE AUTHORISED ";
            }
            return String.format("%d - %s (%s)", response.getStatusCode(), response.getStatusText(), response.getBody());
        }
        return "";
    }

    private Observable<Response> processWithRetry(Request request) {
        return this.processWithCustomRetryCount(request, MAX_RETRIES);
    }

    private Observable<Response> processWithCustomRetryCount(Request request, int retryCount) {
        ExponentialBackOff exponentialBackOff = new ExponentialBackOff();
        exponentialBackOff.setMultiplier((double)BACK_OFF_MULTIPLIER);
        exponentialBackOff.setInitialInterval(BACK_OFF_INITIAL_WAIT);
        exponentialBackOff.setMaxInterval(BACK_OFF_MAX_INTERVAL);
        BackOffExecution backOffExecution = exponentialBackOff.start();
        return this.internalProcessWithRetry(request, null, null, retryCount + 1, retryCount, backOffExecution);
    }

    private Observable<Response> internalProcessWithRetry(final Request request, Response res, Throwable throwable, final int remaining, final int totalRetries, final BackOffExecution exponentialBackOff) {
        if (this.alreadyDisposed) {
            return Observable.error((Throwable)new MQClientConnectionException("Client has already been disposed"));
        }
        if (remaining <= 0) {
            return this.getErrorResponse(res, throwable, totalRetries);
        }
        return this.internalProcess(request).flatMap((Func1)new Func1<Response, Observable<? extends Response>>(){

            public Observable<? extends Response> call(Response response) {
                if (response.getStatusCode() >= 500 && response.getStatusCode() <= 599 || response.getStatusCode() == 429) {
                    return AbstractCourierRestClient.this.getRetryObservable(request, response, exponentialBackOff, null, remaining - 1, totalRetries);
                }
                return Observable.just((Object)response);
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends Response>>(){

            public Observable<? extends Response> call(Throwable th) {
                return AbstractCourierRestClient.this.getRetryObservable(request, null, exponentialBackOff, th, remaining - 1, totalRetries);
            }
        });
    }

    private Observable<Response> getErrorResponse(Response res, Throwable throwable, int totalRetries) {
        if (throwable != null) {
            if (totalRetries == 0) {
                LOGGER.error("There was an error processing operation", throwable);
            } else {
                LOGGER.error("There was an error processing operation after {} retries", (Object)totalRetries, (Object)throwable);
            }
            return Observable.error((Throwable)throwable);
        }
        return Observable.just((Object)res);
    }

    private Observable<? extends Response> getRetryObservable(Request request, Response response, BackOffExecution exponentialBackOff, Throwable throwable, int remaining, int totalRetries) {
        if (this.alreadyDisposed) {
            return Observable.error((Throwable)new MQClientConnectionException("Client has already been disposed"));
        }
        if (remaining == 0 || throwable instanceof RejectedExecutionException) {
            return this.getErrorResponse(response, throwable, totalRetries);
        }
        return Observable.defer(() -> {
            long nextBackOff = this.getExpoBackOffWithJitter(exponentialBackOff);
            LOGGER.warn("There was an error processing operation retrying in {}ms, remaining attempts {}", new Object[]{nextBackOff, remaining, throwable});
            return Observable.timer((long)nextBackOff, (TimeUnit)TimeUnit.MILLISECONDS).flatMap(time -> this.internalProcessWithRetry(request, response, throwable, remaining, totalRetries, exponentialBackOff));
        });
    }

    private long getExpoBackOffWithJitter(BackOffExecution exponentialBackOff) {
        if (exponentialBackOff == null) {
            return BACK_OFF_MAX_INTERVAL;
        }
        long next = exponentialBackOff.nextBackOff();
        if ((next = (long)((float)next * (1.0f + this.rand.nextFloat() * (float)(BACK_OFF_MULTIPLIER - 1L)))) > BACK_OFF_MAX_INTERVAL) {
            next = BACK_OFF_MAX_INTERVAL;
        }
        return next;
    }

    private Observable<Response> internalProcess(final Request request) {
        return this.process(request).flatMap((Func1)new Func1<Response, Observable<Response>>(){

            public Observable<Response> call(Response response) {
                if (response.isUnauthorized()) {
                    return AbstractCourierRestClient.this.regenerateTokenAndRetry(request);
                }
                return Observable.just((Object)response);
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<Response>>(){

            public Observable<Response> call(Throwable throwable) {
                if (AbstractCourierRestClient.this.isUnauthorized(throwable)) {
                    return AbstractCourierRestClient.this.regenerateTokenAndRetry(request);
                }
                LOGGER.debug("An error occurred while processing request {}", (Object)request.toString(), (Object)throwable);
                return Observable.error((Throwable)throwable);
            }
        });
    }

    private Observable<Response> regenerateTokenAndRetry(final Request request) {
        return Observable.just(null).observeOn(Schedulers.newThread()).flatMap((Func1)new Func1<Object, Observable<Response>>(){

            public Observable<Response> call(Object empty) {
                AbstractCourierRestClient.this.resetAccessToken();
                Request retryRequest = AbstractCourierRestClient.this.newRequestBuilderWithAgent().wrap(request).withHeader("Authorization", AbstractCourierRestClient.AUTHENTICATION_TOKEN_TYPE + AbstractCourierRestClient.this.getAccessToken()).build();
                return AbstractCourierRestClient.this.process(retryRequest);
            }
        });
    }

    private boolean isUnauthorized(Throwable throwable) {
        return ClientUtils.ofType(throwable, IllegalStateException.class) && ClientUtils.withMessage(throwable, "401 response received, but no WWW-Authenticate header was present");
    }

    private Observable<FallbackConfigResult> oneResultFallbackConfig(final String operation, Observable<Response> responseObservable) {
        return responseObservable.flatMap((Func1)new Func1<Response, Observable<FallbackConfigResult>>(){

            public Observable<FallbackConfigResult> call(Response response) {
                try {
                    if (response.isOk()) {
                        return Observable.just(JsonUtils.fromJson(response.getBody(), FALLBACK_CONFIG_RESULT_TYPE));
                    }
                    return Observable.error((Throwable)ExceptionFactory.create(operation, response, AbstractCourierRestClient.this.friendlyMessage(response)));
                }
                catch (Exception e) {
                    return Observable.error((Throwable)ExceptionFactory.create(operation, e));
                }
            }
        });
    }

    private Observable<MessageIdResult> oneResult(final String operation, Observable<Response> responseObservable) {
        return responseObservable.flatMap((Func1)new Func1<Response, Observable<MessageIdResult>>(){

            public Observable<MessageIdResult> call(Response response) {
                try {
                    if (response.isOk()) {
                        DefaultMessageIdResult defaultMessageIdResult = (DefaultMessageIdResult)JsonUtils.fromJson(response.getBody(), MESSAGE_ID_RESULT_TYPE);
                        defaultMessageIdResult.setStatusCode(response.getStatusCode());
                        return Observable.just((Object)defaultMessageIdResult);
                    }
                    return Observable.error((Throwable)ExceptionFactory.create(operation, response, AbstractCourierRestClient.this.friendlyMessage(response)));
                }
                catch (Exception e) {
                    return Observable.error((Throwable)ExceptionFactory.create(operation, e));
                }
            }
        });
    }

    private Observable<List<MessageIdResult>> manyResults(final String operation, Observable<Response> responseObservable) {
        return responseObservable.flatMap((Func1)new Func1<Response, Observable<List<MessageIdResult>>>(){

            public Observable<List<MessageIdResult>> call(Response response) {
                try {
                    if (response.isOk()) {
                        return Observable.just(JsonUtils.fromJson(response.getBody(), MESSAGE_IDS_RESULT_TYPE));
                    }
                    return Observable.error((Throwable)ExceptionFactory.create(operation, response, AbstractCourierRestClient.this.friendlyMessage(response)));
                }
                catch (Exception e) {
                    return Observable.error((Throwable)ExceptionFactory.create(operation, e));
                }
            }
        });
    }

    private List<AnypointMQMessage> courierRestMessagesFromJson(String json) {
        List restMessages;
        ArrayList<AnypointMQMessage> messages = new ArrayList<AnypointMQMessage>();
        try {
            restMessages = (List)JsonUtils.fromJson(json, MESSAGES_LIST_TYPE);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Json deserialization error - " + e.getMessage(), e);
        }
        for (AnypointMQReceiveBatchResponse restMessage : restMessages) {
            messages.add(restMessage.convertToAnypointMQMessage());
        }
        return messages;
    }

    protected void logProcessStart(Request request) {
        LOGGER.debug("Sending {} request to {}", (Object)request.getMethod(), (Object)request.getUrl());
    }

    protected void logProcessSuccess(Request request, Response response) {
        LOGGER.debug("Received response from {} {}. Request Id: {}. Response code: {}", new Object[]{request.getMethod(), request.getUrl(), this.getRequestId(response), response.getStatusCode()});
    }

    protected void logProcessError(Request request, Throwable e) {
        if (ClientUtils.isTimeout(e)) {
            LOGGER.debug("Request timed out from {} {}.", (Object)request.getMethod(), (Object)request.getUrl());
        } else if (ClientUtils.isConnectionInterrupted(e)) {
            LOGGER.warn(String.format("Connection unexpectedly closed from %s %s.", new Object[]{request.getMethod(), request.getUrl()}));
            LOGGER.debug(String.format("Connection unexpectedly closed from %s %s.", new Object[]{request.getMethod(), request.getUrl()}), e);
        } else if (ClientUtils.isConnectionRefused(e)) {
            LOGGER.warn(String.format("Can not connect to broker for %s %s.", new Object[]{request.getMethod(), request.getUrl()}));
            LOGGER.debug(String.format("Can not connect to broker for %s %s.", new Object[]{request.getMethod(), request.getUrl()}), e);
        } else {
            LOGGER.warn(String.format("Error from %s %s. %s", new Object[]{request.getMethod(), request.getUrl(), MessageUtils.getCompleteMessage(e)}));
            LOGGER.debug(String.format("Error from %s %s.", new Object[]{request.getMethod(), request.getUrl()}), e);
        }
    }

    private String getRequestId(Response response) {
        try {
            String requestId = response.getHeader("X-Request-Id");
            if (requestId == null || requestId.isEmpty()) {
                requestId = "No-Id";
            }
            return requestId;
        }
        catch (Exception e) {
            return "No-Id";
        }
    }

    private RequestBuilder newRequestBuilderWithAgent() {
        return this.newRequestBuilder().withHeader("User-Agent", this.userAgentInfo);
    }

    protected abstract RequestBuilder newRequestBuilder();

    protected abstract Observable<Response> process(Request var1);
}

