/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.module.boot.extra;

import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;

public abstract class AbstractBootstrapModuleInitializer implements Initialisable, MuleContextAware
{
    private MuleContext context = null;
    
    public AbstractBootstrapModuleInitializer()
    {
        // needed for registry to instantiate
    }

    public void setMuleContext(MuleContext context)
    {
        if(this.context != null)
        {
            throw new UnsupportedOperationException("Mule context is already set");
        }
        this.context = context;
    }

    protected MuleContext getMuleContext()
    {
        return context;
    }
}
