/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.module.boot.extra;

import java.util.prefs.Preferences;

public class BootstrapModuleDescriptor
{
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private String name;
    private boolean enabled;
    private String jarPrefix;
    private String bootstrapLoader;

    public BootstrapModuleDescriptor(Preferences moduleNode)
    {
        this.bootstrapLoader = moduleNode.get("bootstrapLoader", "");
        this.jarPrefix = moduleNode.get("jarPrefix", "");
        this.name = moduleNode.get("name", "");
        this.enabled = moduleNode.getBoolean("enabled", true);
    }

    public Object getBootstrapLoader()
    {
        try
        {
            return Class.forName(bootstrapLoader, true, classLoader).newInstance();
        }
        catch (Exception e)
        {
            return null;
        }
    }

    public String getJarPrefix()
    {
        return jarPrefix;
    }

    public String getName()
    {
        return name;
    }

    public boolean isEnabled()
    {
        return enabled;
    }

    public void setIsEnabled(boolean enabled)
    {
        this.enabled = enabled;
    }
}
