/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.module.boot.extra;

import org.mule.module.boot.MuleBootstrapUtils;

import com.mulesource.licm.EnterpriseLicenseKey;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/**
 * Loads bootstrap module jars into classpath
 */
public class BootstrapModulesLoader
{
    private static Set loadedModules = new LinkedHashSet();

    private File libDir;

    public static void loadModules(File libDir) throws Exception
    {
        loadModules(libDir, null);
    }

    public static void loadModules(File libDir, EnterpriseLicenseKey key) throws Exception
    {
        BootstrapModulesLoader loader = new BootstrapModulesLoader(libDir);

        BootstrapConfigReader.read();
        List modules = BootstrapConfigReader.getBootstrapModules();
        for (int i = 0; i < modules.size(); i++)
        {
            BootstrapModuleDescriptor e = (BootstrapModuleDescriptor) modules.get(i);
            loader.loadModule(e, key);
        }
    }

    public BootstrapModulesLoader(File libDir)
    {
        this.libDir = libDir;
    }

    private void loadModule(BootstrapModuleDescriptor entry, EnterpriseLicenseKey key)
    {

        if (!entry.isEnabled())
        {
            return;
        }

        final String jarPrefix = entry.getJarPrefix();

        if ("".equals(jarPrefix))
        {
            System.out.println(" Jar prefix for module " + entry.getName() + " is empty. Skipping.");
            return;
        }

        BootstrapModuleLoader bootstrapLoader = null;
        try
        {
            File[] files = libDir.listFiles(new FilenameFilter()
            {
                public boolean accept(File dir, String name)
                {
                    return dir.equals(libDir) && name.startsWith(jarPrefix);
                }
            });

            ArrayList urls = new ArrayList();
            for (int i = 0; i < files.length; i++)
            {
                File file = files[i];
                urls.add(file.toURL());
            }

            MuleBootstrapUtils.addLibrariesToClasspath(urls);

            bootstrapLoader = (BootstrapModuleLoader) entry.getBootstrapLoader();

            if (bootstrapLoader == null)
            {
                System.out.println(" Couldn't instantiate bootstrapLoader in bootstrap module "
                                   + entry.getName() + ". Skipping.");
                return;
            }

            // calling module loader
            bootstrapLoader.load();

            loadedModules.add(entry.getName());
        }
        catch (Exception e)
        {
            throw new RuntimeException("Failed to load bootstrap module: name=" + entry.getName()
                                       + " bootstrapLoader=" + bootstrapLoader + " jarPrefix=" + jarPrefix, e);
        }
    }

}
