/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.module.boot.prefs;

import java.util.LinkedHashMap;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;

public class MemoryPreferences extends AbstractPreferences
{
    private final boolean userNode;

    private LinkedHashMap entries = new LinkedHashMap();

    public MemoryPreferences(AbstractPreferences parent, String name, boolean userNode)
    {
        super(parent, name);
        this.userNode = userNode;
    }

    protected void flushSpi() throws BackingStoreException
    {
    }

    protected void removeNodeSpi() throws BackingStoreException
    {
        entries.clear();
    }

    protected void syncSpi() throws BackingStoreException
    {
    }

    protected String[] childrenNamesSpi() throws BackingStoreException
    {
        return new String[0];
    }

    protected String[] keysSpi() throws BackingStoreException
    {
        return (String[]) entries.keySet().toArray(new String[entries.size()]);
    }

    protected void removeSpi(String key)
    {
        entries.remove(key);
    }

    protected String getSpi(String key)
    {
        return (String) entries.get(key);
    }

    protected void putSpi(String key, String value)
    {
        entries.put(key, value);
    }

    protected AbstractPreferences childSpi(String name)
    {
        return new MemoryPreferences(this, name, userNode);
    }

    public boolean isUserNode()
    {
        return userNode;
    }
}
