/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.module.reboot;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * Adds all jars matching pattern: $MULE_HOME/lib/patches/patch-NNNNN-YYYYMMDD.jar before all
 * regular Mule libaries to the classpath.
 */
public class EEMuleClassPathConfig extends DefaultMuleClassPathConfig
{
    protected static String PATCHES_DIR = "lib/patches";

    public EEMuleClassPathConfig(File muleHome, File muleBase)
    {
        super(muleHome, muleBase);
    }

    @Override
    protected void init(File muleHome, File muleBase)
    {
        addPatches(muleHome, muleBase);
        super.init(muleHome, muleBase);
    }

    protected void addPatches(File muleHome, File muleBase)
    {
        try
        {
            File base = determineBaseDirectory(muleHome, muleBase);
            File patchDirectory = new File(base, PATCHES_DIR);
            if (patchDirectory.exists())
            {
                addPatchJars(patchDirectory);
            }

        }
        catch (IOException iox)
        {
            System.out.println("Unable to add patches: " + iox.toString());
        }
    }

    private File determineBaseDirectory(File muleHome, File muleBase) throws IOException
    {
        File homeCanonical = muleHome.getCanonicalFile();
        File baseCanonical = muleBase.getCanonicalFile();
        return homeCanonical.equals(baseCanonical) ? homeCanonical : baseCanonical;
    }

    protected void addPatchJars(File patchDirectory)
    {
        PatchScanner scanner = new PatchScanner(patchDirectory);
        List<File> patchJars = scanner.listPatchJars();
        addFiles(patchJars);
    }
}
