/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.boot;

import com.mulesource.licm.EnterpriseLicenseKey;
import com.mulesource.licm.LicenseKeyException;
import com.mulesource.licm.LicenseManagementFactory;
import com.mulesource.licm.LicenseManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.mule.module.boot.MuleBootstrapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LicenseKeyHandler {
    private static final Logger logger = LoggerFactory.getLogger(LicenseKeyHandler.class);
    private LicenseManager licenseManager;
    public File LICENSE_LOCATION;
    public static final String LICENSE_FILE_NAME = "muleLicenseKey.lic";
    private static EnterpriseLicenseKey key = null;

    public LicenseKeyHandler() {
        try {
            this.licenseManager = LicenseManagementFactory.getInstance().createLicenseManager("mule-ee");
        }
        catch (LicenseKeyException e) {
            logger.error("Error creating License Manager!", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    public EnterpriseLicenseKey install(EnterpriseLicenseKey key) throws LicenseKeyException {
        try {
            this.licenseManager.unInstall();
            this.licenseManager.install(key);
            EnterpriseLicenseKey installedKey = this.licenseManager.validate("mule-ee");
            this.LICENSE_LOCATION = this.lookupMuleBaseConf();
            this.moveLicenseKeyFileToMuleBaseConf();
            File licenseKeyFile = new File(key.getLicenseKeyFile());
            licenseKeyFile.delete();
            return installedKey;
        }
        catch (LicenseKeyException e) {
            logger.error("Couldn't install license key!", (Throwable)e);
            throw e;
        }
    }

    public void unInstall() throws LicenseKeyException {
        try {
            this.licenseManager.unInstall();
        }
        catch (LicenseKeyException e) {
            logger.error("Couldn't uninstall license key!", (Throwable)e);
            throw e;
        }
    }

    public EnterpriseLicenseKey validate() throws LicenseKeyException {
        EnterpriseLicenseKey key = null;
        try {
            key = this.licenseManager.validate("mule-ee");
            if (key.isEvaluation()) {
                this.LICENSE_LOCATION = this.lookupMuleBaseConf();
                this.moveLicenseKeyFileToMuleBaseConf();
            }
        }
        catch (LicenseKeyException licenseKeyException) {
            System.out.println("Couldn't validate license key. Please contact MuleSource Support, support@mulesoft.com, to renew your license.");
        }
        LicenseKeyHandler.key = key;
        return key;
    }

    private void moveLicenseKeyFileToMuleBaseConf() {
        File target;
        boolean success;
        File file;
        URL licenseUrl = Thread.currentThread().getContextClassLoader().getResource(LICENSE_FILE_NAME);
        if (licenseUrl == null && (file = new File(LICENSE_FILE_NAME)).exists() && !(success = file.renameTo(target = new File(this.LICENSE_LOCATION, LICENSE_FILE_NAME)))) {
            try {
                MuleBootstrapUtils.safeCopyFile(file, target);
                file.delete();
            }
            catch (Exception exception) {
                logger.debug("Couldn't move license file from: " + file.getAbsolutePath() + "to: " + target.getAbsolutePath());
            }
        }
    }

    private File lookupMuleBaseConf() {
        File muleHome = null;
        String muleHomeVar = System.getProperty("mule.home");
        if (muleHomeVar != null && !muleHomeVar.trim().equals("") && !muleHomeVar.equals("%MULE_HOME%")) {
            try {
                muleHome = new File(muleHomeVar).getCanonicalFile();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Problem with mule.home!");
            }
        }
        if (muleHome == null || !muleHome.exists() || !muleHome.isDirectory()) {
            throw new IllegalArgumentException("Either MULE_HOME is not set or does not contain a valid directory.");
        }
        File muleBase = null;
        File muleBaseConf = null;
        String muleBaseVar = System.getProperty("mule.base");
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%")) {
            try {
                muleBase = new File(muleBaseVar).getCanonicalFile();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Problem with mule.home!");
            }
        }
        if (muleBase == null) {
            muleBase = muleHome;
        }
        muleBaseConf = new File(muleBase, "conf");
        return muleBaseConf;
    }

    public static EnterpriseLicenseKey getKey() {
        return key;
    }
}

