/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.boot;

import com.mulesource.licm.EnterpriseLicenseKey;
import com.mulesource.licm.LicenseManagementFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.mule.module.boot.LicenseKeyHandler;
import org.mule.module.boot.MuleBootstrapUtils;
import org.mule.module.boot.MuleServerWrapper;
import org.mule.module.boot.VersionWrapper;
import org.mule.module.boot.extra.BootstrapModulesLoader;
import org.mule.util.ClassUtils;
import org.mule.util.PropertiesUtils;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperSimpleApp;

public class MuleBootstrap {
    private static final String MULE_MODULE_BOOT_POM_FILE_PATH = "META-INF/maven/com.mulesoft.muleesb.modules/mule-module-boot/pom.properties";
    private static final String TESTING_MODE_PROPERTY_NAME = "mule.testingMode";
    public static final String MAIN_CLASS_MULE_SERVER = "org.mule.module.boot.MuleServerWrapper";
    public static final String[][] CLI_OPTIONS = new String[][]{{"main", "true", "Main Class"}, {"nogui", "false", "Suppress graphical console"}, {"version", "false", "Show product and version information"}, {"installLicense", "true", "Replace current license with new license supplied"}, {"unInstallLicense", "false", "Uninstall current license"}, {"verifyLicense", "false", "Prints currently installed license details"}};

    public static void main(String[] args) throws Exception {
        CommandLine commandLine = MuleBootstrap.parseCommandLine(args);
        String[] remainingArgs = commandLine.getArgs();
        String mainClassName = commandLine.getOptionValue("main");
        EnterpriseLicenseKey key = MuleBootstrap.handleLicenseKey(commandLine);
        if (commandLine.hasOption("version")) {
            MuleBootstrap.startAndShowVersion(remainingArgs, key);
        } else if (mainClassName == null || mainClassName.equals(MAIN_CLASS_MULE_SERVER)) {
            MuleBootstrap.prepareBootstrapPhase(key);
            System.out.println("Starting the Mule Server...");
            WrapperManager.start((WrapperListener)((WrapperListener)Class.forName(MAIN_CLASS_MULE_SERVER).newInstance()), (String[])remainingArgs);
        } else {
            String[] appArgs = new String[remainingArgs.length + 1];
            appArgs[0] = mainClassName;
            System.arraycopy(remainingArgs, 0, appArgs, 1, remainingArgs.length);
            MuleBootstrap.prepareBootstrapPhase(key);
            System.out.println("Starting class " + mainClassName + "...");
            WrapperSimpleApp.main((String[])appArgs);
        }
    }

    private static void startAndShowVersion(String[] remainingArgs, EnterpriseLicenseKey key) throws Exception {
        MuleBootstrap.prepareBootstrapPhase(key);
        WrapperManager.start((WrapperListener)new VersionWrapper(), (String[])remainingArgs);
    }

    private static void prepareBootstrapPhase(EnterpriseLicenseKey key) throws Exception {
        File muleHome = MuleBootstrap.lookupMuleHome();
        File muleBase = MuleBootstrap.lookupMuleBase();
        if (muleBase == null) {
            muleBase = muleHome;
        }
        BootstrapModulesLoader.loadModules(MuleBootstrapUtils.getMuleModuleDir(), key);
        MuleBootstrapUtils.addLocalJarFilesToClasspath(muleHome, muleBase);
        MuleBootstrap.setSystemMuleVersion();
    }

    protected static File lookupMuleHome() throws Exception {
        File muleHome = null;
        String muleHomeVar = System.getProperty("mule.home");
        if (muleHomeVar != null && !muleHomeVar.trim().equals("") && !muleHomeVar.equals("%MULE_HOME%")) {
            muleHome = new File(muleHomeVar).getCanonicalFile();
        }
        if (muleHome == null || !muleHome.exists() || !muleHome.isDirectory()) {
            throw new IllegalArgumentException("Either MULE_HOME is not set or does not contain a valid directory.");
        }
        return muleHome;
    }

    protected static File lookupMuleBase() throws Exception {
        File muleBase = null;
        String muleBaseVar = System.getProperty("mule.base");
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%")) {
            muleBase = new File(muleBaseVar).getCanonicalFile();
        }
        return muleBase;
    }

    private static void setSystemMuleVersion() {
        try {
            URL mavenPropertiesUrl = ClassUtils.getResource((String)MULE_MODULE_BOOT_POM_FILE_PATH, MuleServerWrapper.class);
            Properties mavenProperties = PropertiesUtils.loadProperties((URL)mavenPropertiesUrl);
            System.setProperty("mule.version", mavenProperties.getProperty("version"));
            System.setProperty("mule.reference.version", String.valueOf(mavenProperties.getProperty("version")) + '-' + new Date().getTime());
        }
        catch (Exception exception) {}
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        int i = 0;
        while (i < CLI_OPTIONS.length) {
            options.addOption(CLI_OPTIONS[i][0], "true".equalsIgnoreCase(CLI_OPTIONS[i][1]), CLI_OPTIONS[i][2]);
            ++i;
        }
        return new BasicParser().parse(options, args, true);
    }

    private static EnterpriseLicenseKey handleLicenseKey(CommandLine commandLine) throws Exception {
        LicenseKeyHandler licenseKeyHandler = new LicenseKeyHandler();
        EnterpriseLicenseKey key = LicenseManagementFactory.getInstance().createLicenseKey("mule-ee");
        if (commandLine.hasOption("installLicense")) {
            String keyRequestFile = commandLine.getOptionValue("installLicense");
            File keyRequest = new File(keyRequestFile);
            if (!keyRequest.exists()) {
                throw new IOException("License key file - " + keyRequestFile + " not found!");
            }
            key.setLicenseKeyFile(keyRequestFile);
            EnterpriseLicenseKey newKey = licenseKeyHandler.install(key);
            System.out.println();
            System.out.println("Installed license key.");
            System.out.println(newKey);
            System.out.println();
            MuleBootstrap.startAndShowVersion(new String[0], key);
            WrapperManager.stop((int)0);
        } else if (commandLine.hasOption("unInstallLicense")) {
            licenseKeyHandler.unInstall();
            System.out.println();
            System.out.println("Uninstalled license key.");
            System.out.println();
            MuleBootstrap.startAndShowVersion(new String[0], key);
            WrapperManager.stop((int)0);
        } else if (commandLine.hasOption("verifyLicense")) {
            key = licenseKeyHandler.validate();
            if (key != null) {
                System.out.println();
                System.out.println("Valid license key --> " + key);
                System.out.println();
            }
            MuleBootstrap.startAndShowVersion(new String[0], key);
            WrapperManager.stop((int)0);
        } else {
            key = licenseKeyHandler.validate();
            if (key != null) {
                if (System.getProperty(TESTING_MODE_PROPERTY_NAME) != null) {
                    System.out.println();
                    System.out.println("Running Mule on testing mode");
                    System.out.println();
                } else {
                    System.out.println();
                    System.out.println("Valid license key --> " + key);
                    System.out.println();
                }
            } else {
                MuleBootstrap.startAndShowVersion(new String[0], key);
                WrapperManager.stop((int)0);
            }
        }
        return key;
    }
}

