/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.mule.module.boot.DefaultMuleClassPathConfig;

public final class MuleBootstrapUtils {
    private static final String MULE_MODULE_FILENAME = "lib" + File.separator + "module";
    private static final String MULE_LIB_FILENAME = "lib" + File.separator + "mule";
    private static final String MULE_HOME = System.getProperty("mule.home");
    public static final String MULE_LOCAL_JAR_FILENAME = "mule-local-install.jar";

    private MuleBootstrapUtils() {
    }

    public static boolean isStandalone() {
        return MULE_HOME != null;
    }

    public static File getMuleHomeFile() {
        return new File(MULE_HOME);
    }

    public static File getMuleLibDir() {
        return new File(String.valueOf(MULE_HOME) + File.separator + MULE_LIB_FILENAME);
    }

    public static File getMuleModuleDir() {
        return new File(String.valueOf(MULE_HOME) + File.separator + MULE_MODULE_FILENAME);
    }

    public static File getMuleLocalJarFile() {
        return new File(MuleBootstrapUtils.getMuleLibDir(), MULE_LOCAL_JAR_FILENAME);
    }

    public static void addLocalJarFilesToClasspath(File muleHome, File muleBase) throws Exception {
        DefaultMuleClassPathConfig classPath = new DefaultMuleClassPathConfig(muleHome, muleBase);
        MuleBootstrapUtils.addLibrariesToClasspath(classPath.getURLs());
    }

    public static void addLibrariesToClasspath(List urls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader sys = ClassLoader.getSystemClassLoader();
        if (!(sys instanceof URLClassLoader)) {
            throw new IllegalArgumentException("PANIC: Mule has been started with an unsupported classloader: " + sys.getClass().getName() + ". " + "Please report this error to user<at>mule<dot>codehaus<dot>org");
        }
        URLClassLoader sysCl = (URLClassLoader)sys;
        Class<URLClassLoader> refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        for (URL url : urls) {
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }

    public static void safeCopyFile(File in, File out) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        try {
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static class ProxyInfo {
        public final String host;
        public final String port;
        public final String username;
        public final String password;

        public ProxyInfo(String host, String port) {
            this(host, port, null, null);
        }

        public ProxyInfo(String host, String port, String username, String password) {
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
        }
    }
}

