/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.boot.extra;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import org.mule.module.boot.extra.BootstrapModuleDescriptor;

public class BootstrapConfigReader {
    private static final String CONFIG_FILE = "extra-bootstrap-modules.xml";
    private static List bootstrapModules = new ArrayList();

    public static void read() {
        if (System.getProperty("java.util.prefs.PreferencesFactory") == null) {
            System.setProperty("java.util.prefs.PreferencesFactory", "org.mule.module.boot.prefs.MemoryPreferencesFactory");
        }
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(CONFIG_FILE);
            try {
                Preferences.importPreferences(is);
                is.close();
            }
            catch (IOException iOException) {
                System.out.println("extra-bootstrap-modules.xml not found. Extra features disabled.");
                bootstrapModules = Collections.EMPTY_LIST;
                return;
            }
            String[] children = Preferences.systemRoot().childrenNames();
            if (children.length > 0) {
                bootstrapModules.clear();
            }
            int i = 0;
            while (i < children.length) {
                if (Preferences.systemRoot().node(children[i]).get("bootstrapLoader", "").compareToIgnoreCase("") != 0) {
                    bootstrapModules.add(new BootstrapModuleDescriptor(Preferences.systemRoot().node(children[i])));
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Invalid extra-bootstrap-modules.xml");
            e.printStackTrace();
            bootstrapModules = Collections.EMPTY_LIST;
        }
    }

    public static List getBootstrapModules() {
        return bootstrapModules;
    }
}

