/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.boot.extra;

import com.mulesource.licm.EnterpriseLicenseKey;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.mule.module.boot.MuleBootstrapUtils;
import org.mule.module.boot.extra.BootstrapConfigReader;
import org.mule.module.boot.extra.BootstrapModuleDescriptor;
import org.mule.module.boot.extra.BootstrapModuleLoader;

public class BootstrapModulesLoader {
    private static Set loadedModules = new LinkedHashSet();
    private File libDir;

    public static void loadModules(File libDir) throws Exception {
        BootstrapModulesLoader.loadModules(libDir, null);
    }

    public static void loadModules(File libDir, EnterpriseLicenseKey key) throws Exception {
        BootstrapModulesLoader loader = new BootstrapModulesLoader(libDir);
        BootstrapConfigReader.read();
        List modules = BootstrapConfigReader.getBootstrapModules();
        int i = 0;
        while (i < modules.size()) {
            BootstrapModuleDescriptor e = (BootstrapModuleDescriptor)modules.get(i);
            loader.loadModule(e, key);
            ++i;
        }
    }

    public BootstrapModulesLoader(File libDir) {
        this.libDir = libDir;
    }

    private void loadModule(BootstrapModuleDescriptor entry, EnterpriseLicenseKey key) {
        if (!entry.isEnabled()) {
            return;
        }
        final String jarPrefix = entry.getJarPrefix();
        if ("".equals(jarPrefix)) {
            System.out.println(" Jar prefix for module " + entry.getName() + " is empty. Skipping.");
            return;
        }
        BootstrapModuleLoader bootstrapLoader = null;
        try {
            File[] files = this.libDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return dir.equals(BootstrapModulesLoader.this.libDir) && name.startsWith(jarPrefix);
                }
            });
            ArrayList<URL> urls = new ArrayList<URL>();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                urls.add(file.toURL());
                ++i;
            }
            MuleBootstrapUtils.addLibrariesToClasspath(urls);
            bootstrapLoader = (BootstrapModuleLoader)entry.getBootstrapLoader();
            if (bootstrapLoader == null) {
                System.out.println(" Couldn't instantiate bootstrapLoader in bootstrap module " + entry.getName() + ". Skipping.");
                return;
            }
            bootstrapLoader.load();
            loadedModules.add(entry.getName());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load bootstrap module: name=" + entry.getName() + " bootstrapLoader=" + bootstrapLoader + " jarPrefix=" + jarPrefix, e);
        }
    }
}

