/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.reboot;

import com.mulesource.licm.EnterpriseLicenseKey;
import com.mulesource.licm.LicenseManagementFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.mule.module.boot.LicenseKeyHandler;
import org.mule.module.reboot.EEMuleContainerBootstrap;
import org.mule.module.reboot.EEMuleContainerWrapper;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.module.reboot.MuleContainerWrapper;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.event.WrapperEvent;
import org.tanukisoftware.wrapper.event.WrapperEventListener;

public class MuleContainerBootstrap {
    private static final String MULE_MODULE_BOOT_POM_FILE_PATH = "META-INF/maven/org.mule.module/mule-module-boot/pom.properties";
    private static final String TESTING_MODE_PROPERTY_NAME = "mule.testingMode";
    public static final String[][] CLI_OPTIONS = new String[][]{{"main", "true", "Main Class"}, {"installLicense", "true", "Replace current license with new license supplied"}, {"unInstallLicense", "false", "Uninstall current license"}, {"verifyLicense", "false", "Prints currently installed license details"}, {"version", "false", "Show product and version information"}};

    public static void main(String[] args) throws Exception {
        String[] remainingArgs = null;
        Integer requestedExitCode = null;
        String errorMessage = null;
        try {
            CommandLine commandLine = MuleContainerBootstrap.parseCommandLine(args);
            remainingArgs = commandLine.getArgs();
            requestedExitCode = MuleContainerBootstrap.handleLicenseKey(commandLine);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            requestedExitCode = 1;
            errorMessage = ex.getMessage();
        }
        if (requestedExitCode != null) {
            final String errorMessageToLog = errorMessage;
            WrapperManager.addWrapperEventListener((WrapperEventListener)new WrapperEventListener(){
                private boolean errorAlreadyLogged = false;

                public void fired(WrapperEvent event) {
                    if (!this.errorAlreadyLogged && errorMessageToLog != null) {
                        WrapperManager.log((int)5, (String)errorMessageToLog);
                        this.errorAlreadyLogged = true;
                    }
                }
            }, (long)4L);
            WrapperManager.start((WrapperListener)new WrapperListener(){

                public Integer start(String[] args) {
                    return null;
                }

                public int stop(int exitCode) {
                    return exitCode;
                }

                public void controlEvent(int event) {
                }
            }, (String[])new String[0]);
            WrapperManager.stop((int)requestedExitCode);
        } else {
            MuleContainerBootstrap.prepareBootstrapPhase();
            System.out.println("Starting the Mule Container...");
            WrapperManager.start((WrapperListener)new EEMuleContainerWrapper(), (String[])remainingArgs);
        }
    }

    private static void prepareBootstrapPhase() throws Exception {
        File muleHome = MuleContainerBootstrap.lookupMuleHome();
        File muleBase = MuleContainerBootstrap.lookupMuleBase();
        if (muleBase == null) {
            muleBase = muleHome;
        }
        MuleContainerBootstrap.setSystemMuleVersion();
    }

    public static File lookupMuleHome() throws Exception {
        File muleHome = null;
        String muleHomeVar = System.getProperty("mule.home");
        if (muleHomeVar != null && !muleHomeVar.trim().equals("") && !muleHomeVar.equals("%MULE_HOME%")) {
            muleHome = new File(muleHomeVar).getCanonicalFile();
        }
        if (muleHome == null || !muleHome.exists() || !muleHome.isDirectory()) {
            throw new IllegalArgumentException("Either the system property mule.home is not set or does not contain a valid directory.");
        }
        return muleHome;
    }

    public static File lookupMuleBase() throws Exception {
        File muleBase = null;
        String muleBaseVar = System.getProperty("mule.base");
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%")) {
            muleBase = new File(muleBaseVar).getCanonicalFile();
        }
        return muleBase;
    }

    private static void setSystemMuleVersion() {
        block14: {
            InputStream propertiesStream = null;
            try {
                try {
                    URL mavenPropertiesUrl = MuleContainerBootstrapUtils.getResource(MULE_MODULE_BOOT_POM_FILE_PATH, MuleContainerWrapper.class);
                    propertiesStream = mavenPropertiesUrl.openStream();
                    Properties mavenProperties = new Properties();
                    mavenProperties.load(propertiesStream);
                    System.setProperty("mule.version", mavenProperties.getProperty("version"));
                    System.setProperty("mule.reference.version", String.valueOf(mavenProperties.getProperty("version")) + '-' + new Date().getTime());
                }
                catch (Exception exception) {
                    if (propertiesStream != null) {
                        try {
                            propertiesStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (propertiesStream != null) {
                    try {
                        propertiesStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (propertiesStream != null) {
                try {
                    propertiesStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        int i = 0;
        while (i < CLI_OPTIONS.length) {
            options.addOption(CLI_OPTIONS[i][0], "true".equalsIgnoreCase(CLI_OPTIONS[i][1]), CLI_OPTIONS[i][2]);
            ++i;
        }
        return new BasicParser().parse(options, args, true);
    }

    private static Integer handleLicenseKey(CommandLine commandLine) throws Exception {
        LicenseKeyHandler licenseKeyHandler = new LicenseKeyHandler();
        EnterpriseLicenseKey key = LicenseManagementFactory.getInstance().createLicenseKey("mule-ee");
        if (commandLine.hasOption("installLicense")) {
            String keyRequestFile = commandLine.getOptionValue("installLicense");
            File keyRequest = new File(keyRequestFile);
            if (!keyRequest.exists()) {
                throw new IOException("License key file - " + keyRequestFile + " not found!");
            }
            key.setLicenseKeyFile(keyRequestFile);
            EnterpriseLicenseKey newKey = licenseKeyHandler.install(key);
            System.out.println();
            System.out.println("Installed license key.");
            System.out.println(newKey);
            System.out.println();
            return 0;
        }
        if (commandLine.hasOption("unInstallLicense")) {
            licenseKeyHandler.unInstall();
            System.out.println();
            System.out.println("Uninstalled license key.");
            System.out.println();
            return 0;
        }
        if (commandLine.hasOption("verifyLicense")) {
            key = licenseKeyHandler.validate();
            if (key != null) {
                System.out.println();
                System.out.println("Valid license key --> " + key);
                System.out.println();
                return 0;
            }
            return 1;
        }
        key = licenseKeyHandler.validate();
        if (key != null) {
            if (System.getProperty(TESTING_MODE_PROPERTY_NAME) != null) {
                EEMuleContainerBootstrap.setKey(key, true);
                System.out.println();
                System.out.println("Running Mule on testing mode");
                System.out.println();
            } else {
                EEMuleContainerBootstrap.setKey(key, false);
                System.out.println();
                System.out.println("Valid license key --> " + key);
                System.out.println();
            }
        } else {
            System.out.println("invalid license key, stopping now");
            return 1;
        }
        return null;
    }
}

