/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.reboot;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;

public class PatchScanner {
    protected static Pattern PATCH_PATTERN = Pattern.compile(".*[\\\\/]patch-\\w+-\\d{8}.jar$");
    protected File patchDirectory;
    protected Map<String, File> classes;
    protected Map<String, Set<File>> duplicates;

    public PatchScanner(File patchDirectory) {
        this.patchDirectory = patchDirectory;
        this.classes = new HashMap<String, File>();
        this.duplicates = new HashMap<String, Set<File>>();
    }

    public List<File> listPatchJars() {
        List<File> patchJars = this.getPatchJars();
        this.scanForDuplicateClasses(patchJars);
        if (this.duplicates.size() > 0) {
            this.createErrorMessageAndThrow();
        }
        return patchJars;
    }

    protected List<File> getPatchJars() {
        File[] jars = this.patchDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                try {
                    return PATCH_PATTERN.matcher(pathname.getCanonicalPath()).matches();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        });
        if (jars != null) {
            return Arrays.asList(jars);
        }
        return Collections.emptyList();
    }

    private void scanForDuplicateClasses(List<File> patchJars) {
        try {
            for (File jar : patchJars) {
                this.scanJarForDuplicateClasses(jar);
            }
        }
        catch (IOException iox) {
            throw new IllegalStateException(iox);
        }
    }

    protected void scanJarForDuplicateClasses(File jarFile) throws IOException {
        try (ZipInputStream jarStream = null;){
            jarStream = new JarInputStream(new FileInputStream(jarFile));
            this.scanStreamForDuplicateClasses((JarInputStream)jarStream, jarFile);
        }
    }

    private void scanStreamForDuplicateClasses(JarInputStream jarStream, File sourceFile) throws IOException {
        JarEntry entry;
        while ((entry = jarStream.getNextJarEntry()) != null) {
            String name;
            if (entry.isDirectory() || (name = entry.getName()).startsWith("META-INF")) continue;
            File patchFile = this.classes.get(name);
            if (patchFile != null) {
                this.addDuplicate(name, patchFile, sourceFile);
            }
            this.classes.put(name, sourceFile);
        }
    }

    private void addDuplicate(String name, File fileOne, File fileTwo) {
        Set<File> set = this.duplicates.get(name);
        if (set == null) {
            set = new HashSet<File>();
            this.duplicates.put(name, set);
        }
        set.add(fileOne);
        set.add(fileTwo);
    }

    private void createErrorMessageAndThrow() {
        StringBuilder errorMessage = new StringBuilder(512);
        errorMessage.append("\n\nDuplicate classes in patch jars detected:\n\n");
        for (Map.Entry<String, Set<File>> entry : this.duplicates.entrySet()) {
            String className = entry.getKey();
            Set<File> containingJars = entry.getValue();
            errorMessage.append("Patch jars ");
            errorMessage.append(containingJars.toString());
            errorMessage.append(" all contain duplicate class ");
            className = className.replace('/', '.');
            className = className.replace(".class", "");
            errorMessage.append(className);
            errorMessage.append("\n");
        }
        throw new IllegalStateException(errorMessage.toString());
    }
}

