/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.mule;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.DefaultsConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;

import com.mulesoft.mule.module.datamapper.DataMapperModule;

import org.jetel.graph.dictionary.Dictionary;
import org.jetel.graph.dictionary.DictionaryEntry;

public class DefaultMuleContextAccessor implements MuleContextAccessor
{

    private Dictionary dictionary;

    public DefaultMuleContextAccessor(Dictionary dictionary)
    {
        this.dictionary = dictionary;
    }

    @Override
    public MuleContext getMuleContext()
    {
        DictionaryEntry entry = dictionary.getEntry(DataMapperModule.MULE_CONTEXT);
        return entry != null && entry.getValue() != null ? (MuleContext) entry.getValue() : null;
    }

    @Override
    public MuleEvent getMuleEvent(){
        DictionaryEntry entry = dictionary.getEntry(DataMapperModule.MULE_EVENT);
        return entry != null && entry.getValue() != null ? (MuleEvent) entry.getValue() : null;
    }

    @Override
    public void postExecute()
    {

    }



}
