package com.mulesoft.datamapper.mule;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.DefaultsConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;

/**
 * Mule Context provider for preview
 */
public class PreviewMuleContextAccessor implements MuleContextAccessor

{

    public static final String PREVIEW = "preview";
    private MuleContext muleContext;

    @Override
    public MuleContext getMuleContext()
    {
        if (muleContext == null)
        {
            muleContext = createNewMuleContext();
        }
        return muleContext;
    }

    @Override
    public MuleEvent getMuleEvent()
    {
        return null;
    }

    @Override
    public void postExecute()
    {
        if (muleContext != null)
        {
            muleContext.dispose();
            muleContext = null;
        }

    }

    public MuleContext createNewMuleContext()
    {
        //Set the clover GreedyClassLoader as the context ClassLoader. This is a hack to make mule work on DM preview.
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        DefaultMuleContextBuilder defaultMuleContextBuilder = new DefaultMuleContextBuilder();
        defaultMuleContextBuilder.setMuleConfiguration(new DefaultMuleConfiguration(true));
        MuleContext muleContext = defaultMuleContextBuilder.buildMuleContext();
        try
        {
            muleContext.getRegistry().registerObject(PREVIEW, Boolean.TRUE);
            muleContext.initialise();
        }
        catch (InitialisationException e)
        {

        }
        catch (RegistrationException e)
        {

        }
        DefaultsConfigurationBuilder defaultsConfigurationBuilder = new DefaultsConfigurationBuilder();
        try
        {
            defaultsConfigurationBuilder.configure(muleContext);
        }
        catch (ConfigurationException e)
        {

        }
        return muleContext;
    }

    public static Boolean isRunningOnPreview(MuleContext muleContext)
    {
        return muleContext.getRegistry().get(PreviewMuleContextAccessor.PREVIEW) != null;
    }
}
