/**
 *
 */
package com.mulesoft.datamapper.transform;

import java.math.BigDecimal;
import java.util.Date;

import org.jetel.metadata.DataFieldType;

public class CloverTypesUtils
{

    public static Class<?> getJavaClassFromFieldType(DataFieldType dataType)
    {
        Class<?> desiredType;
        switch (dataType)
        {
            case STRING:
                desiredType = String.class;
                break;
            case BOOLEAN:
                desiredType = Boolean.class;
                break;
            case INTEGER:
                desiredType = Integer.class;
                break;
            case LONG:
                desiredType = Long.class;
                break;
            case DATE:
                desiredType = Date.class;
                break;
            case NUMBER:
                desiredType = Double.class;
                break;
            case DECIMAL:
                desiredType = BigDecimal.class;
                break;
            case BYTE:
            case CBYTE:
                desiredType = Byte.class;
                break;
            default:
                desiredType = dataType.getInternalValueClass();
                break;
        }
        return desiredType;
    }

    public static DataFieldType getFieldTypeFromJavaClass(Class dataType)
    {
        if (String.class.isAssignableFrom(dataType))
        {
            return DataFieldType.STRING;
        }
        else if (Boolean.class.isAssignableFrom(dataType))
        {
            return DataFieldType.BOOLEAN;
        }
        else if (Integer.class.isAssignableFrom(dataType))
        {
            return DataFieldType.INTEGER;
        }
        else if (Long.class.isAssignableFrom(dataType))
        {
            return DataFieldType.LONG;
        }
        else if (Date.class.isAssignableFrom(dataType))
        {
            return DataFieldType.DATE;
        }
        else if (Double.class.isAssignableFrom(dataType))
        {
            return DataFieldType.NUMBER;
        }
        else if (BigDecimal.class.isAssignableFrom(dataType))
        {
            return DataFieldType.BYTE;
        }

        return DataFieldType.STRING;
    }
}
