/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform;

import org.mule.el.context.AbstractMapContext;

import com.mulesoft.datamapper.transform.converter.ScalarValueConversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.jetel.data.DataField;
import org.jetel.data.DataRecord;
import org.jetel.data.DecimalDataField;
import org.jetel.data.ListDataField;
import org.jetel.data.StringDataField;

public class DataRecordContext extends AbstractMapContext<String, Object>
{

    private DataRecord dataRecord;
    private ScalarValueConversion conversion = ScalarValueConversion.theInstance();

    public DataRecordContext(DataRecord dataRecord)
    {
        this.dataRecord = dataRecord;
    }

    @Override
    public boolean containsKey(Object key)
    {
        return dataRecord.hasField(String.valueOf(key));
    }

    @Override
    public Object get(Object key)
    {
        DataField field = dataRecord.getField(String.valueOf(key));
        if (field != null)
        {
            return getDataFieldValue(field);
        }
        else
        {
            throw new IllegalArgumentException("Field '" + String.valueOf(key) + "' is not declared at  "
                                               + dataRecord.getMetadata().getName());
        }
    }

    private Object getDataFieldValue(DataField field)
    {
        if (field.isNull())
        {
            return null;
        }
        else if (field instanceof StringDataField)
        {
            return field.getValue().toString();
        }
        else if (field instanceof DecimalDataField)
        {
            return ((DecimalDataField) field).getBigDecimal();
        }
        else if (field instanceof ListDataField)
        {
            ListDataField cloverList = (ListDataField) field;
            List<Object> list = new ArrayList<Object>();
            for (int i = 0; i < cloverList.getSize(); i++)
            {
                list.add(getDataFieldValue(cloverList.getField(i)));
            }
            return list;
        }
        else
        {
            return field.getValue();
        }
    }

    @Override
    public Object put(String key, Object value)
    {
        DataField field = dataRecord.getField(key);
        if (field != null)
        {
            setDataFieldValue(field, value);
            return value;
        }
        else
        {
            throw new IllegalArgumentException("Field '" + String.valueOf(key) + "' is not declared at  "
                                               + dataRecord.getMetadata().getName());
        }
    }

    private void setDataFieldValue(DataField field, Object value)
    {
        if (value == null)
        {
            field.setNull(true);
        }
        else if (field instanceof StringDataField)
        {
            field.setValue(value.toString());
        }
        else if (field instanceof ListDataField)
        {
            ListDataField cloverList = (ListDataField) field;
            Class<?> listType = field.getMetadata().getDataType().getInternalValueClass();
            if(listType.isArray()){
                listType = listType.getComponentType();
            }
            cloverList.setValue(conversion.convertList(value, listType));
        }
        else
        {
            Class<?> desiredType = field.getMetadata().getDataType().getInternalValueClass();
            if (desiredType == value.getClass())
            {
                field.setValue(value);
            }
            else
            {
                field.setValue(conversion.convert(value, desiredType));


            }
        }
    }

    @Override
    public Object remove(Object key)
    {
        throw new UnsupportedOperationException("Can not remove from a data record");

    }

    @Override
    public void clear()
    {
        throw new UnsupportedOperationException("Can not clear a data record");
    }

    @Override
    public Set<String> keySet()
    {
        return new HashSet<String>(Arrays.asList(dataRecord.getMetadata().getFieldNamesArray()));
    }
}
