/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform;

import org.jetel.exception.ComponentNotReadyException;
import org.jetel.graph.dictionary.Dictionary;

import org.mule.el.context.AbstractMapContext;

import java.util.HashSet;
import java.util.Set;

public class InputArgumentContext extends AbstractMapContext<String, Object>
{

    private Dictionary dictionary;

    public InputArgumentContext(Dictionary dictionary)
    {
        this.dictionary = dictionary;
    }

    @Override
    public boolean containsKey(Object key)
    {
        return dictionary.isInput(String.valueOf(key));
    }

    @Override
    public Object get(Object key)
    {
        if (!containsKey(key))
        {
            throw new IllegalArgumentException("Input Argument '" + String.valueOf(key) + "' is not declared.");
        }
        return dictionary.getValue(String.valueOf(key));
    }

    @Override
    public Object put(String s, Object o)
    {
        throw new UnsupportedOperationException("Entry is not output type and can not be assigned");
    }

    @Override
    public Object remove(Object o)
    {
        return null;
    }

    @Override
    public void clear()
    {

    }

    @Override
    public Set<String> keySet()
    {
        final Set<String> result = new HashSet<String>();
        final Set<String> dictionaryKeys = dictionary.getKeys();
        for (String key : dictionaryKeys)
        {
            if (dictionary.isInput(key))
            {
                result.add(key);
            }
        }
        return result;
    }
}
