/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform;

import org.jetel.data.lookup.LookupTable;
import org.jetel.graph.TransformationGraph;

import java.util.Iterator;

public class LookupTableAwareImpl implements LookupTableAware
{

    private TransformationGraph graph;

    public LookupTableAwareImpl(TransformationGraph graph)
    {
        this.graph = graph;
    }

    @Override
    public LookupTable getLookupTable(String name)
    {
        return graph.getLookupTable(name);
    }

    @Override
    public Iterator<String> getLookupTables()
    {
        return graph.getLookupTables();
    }
}
