/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform;

import org.mule.el.mvel.DataMapperExpressionLanguage;

import com.mulesoft.datamapper.mule.MuleContextAccessor;
import com.mulesoft.datamapper.mule.MuleContextAccessorFactory;

import org.jetel.component.DataRecordTransform;
import org.jetel.data.DataRecord;
import org.jetel.exception.ComponentNotReadyException;
import org.jetel.exception.TransformException;

public class MelRecordTransform extends DataRecordTransform
{

    public static final String MEL_SCRIPT = "melScript";
    private DataMapperExpressionLanguage dmExpressionLanguage;
    private MuleContextAccessor muleContextAccessor;


    private void initIfRequired()
    {
        if (dmExpressionLanguage == null)
        {

            muleContextAccessor = MuleContextAccessorFactory.create(getGraph().getDictionary());
            dmExpressionLanguage = new DataMapperExpressionLanguage(muleContextAccessor.getMuleContext(), getGraph().getRuntimeContext().getClassLoader(), new LookupTableAwareImpl(getGraph()), getGraph().getDictionary());
        }
    }

    @Override
    public int transform(DataRecord[] inputRecords, DataRecord[] outputRecords) throws TransformException
    {

        initIfRequired();
        //Need to set the context classloader
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = getGraph().getRuntimeContext().getClassLoader();
        if (classLoader != null)
        {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        try
        {
            String transform = parameters.getProperty(MEL_SCRIPT);
            dmExpressionLanguage.evaluate(transform, inputRecords, outputRecords[0]);
        }
        finally
        {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }

        //Need to set the context classloader
        return 0;
    }

    @Override
    public void postExecute() throws ComponentNotReadyException
    {
        super.postExecute();
        if(muleContextAccessor != null)
        {
            muleContextAccessor.postExecute();
        }
    }
}
