/*
 * CloverETL Engine - Java based ETL application framework.
 * Copyright (c) Javlin, a.s. (info@cloveretl.com).  Use is subject to license terms.
 *
 * www.cloveretl.com
 */
package com.mulesoft.datamapper.transform.converter;

import java.math.BigDecimal;

import org.apache.commons.beanutils.Converter;
import org.jetel.data.primitive.Decimal;

/**
 * @author jan.michalica (info@cloveretl.com)
 *         (c) Javlin, a.s. (www.cloveretl.com)
 * @created 31.7.2012
 */
public class BigDecimalConverter implements Converter
{

    private org.apache.commons.beanutils.converters.BigDecimalConverter delegate =
            new org.apache.commons.beanutils.converters.BigDecimalConverter();

    @Override
    public Object convert(Class type, Object value)
    {

        if (value instanceof Decimal && BigDecimal.class.equals(type))
        {
            Decimal decimal = (Decimal) value;
            return decimal.getBigDecimal();
        }
        return delegate.convert(type, value);
    }
}
