/*
 * CloverETL Engine - Java based ETL application framework.
 * Copyright (c) Javlin, a.s. (info@cloveretl.com).  Use is subject to license terms.
 *
 * www.cloveretl.com
 */
package com.mulesoft.datamapper.transform.converter;

import java.math.BigDecimal;
import java.math.BigInteger;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.jetel.data.primitive.Decimal;
import org.jetel.data.primitive.DecimalFactory;

/**
 * @author jan.michalica (info@cloveretl.com)
 *         (c) Javlin, a.s. (www.cloveretl.com)
 * @created 24.7.2012
 */
@SuppressWarnings("rawtypes")
public class DecimalConverter extends AbstractConverter
{

    @Override
    protected Object convertToType(Class type, Object value) throws Throwable
    {

        if (value instanceof BigDecimal)
        {
            BigDecimal bd = (BigDecimal) value;
            return DecimalFactory.getDecimal(bd);
        }
        if (value instanceof BigInteger)
        {
            BigInteger bi = (BigInteger) value;
            return DecimalFactory.getDecimal(new BigDecimal(bi));
        }
        if (value instanceof Integer || value instanceof Short || value instanceof Byte)
        {
            Number number = (Number) value;
            return DecimalFactory.getDecimal(number.intValue());
        }
        if (value instanceof Float || value instanceof Double)
        {
            Number number = (Number) value;
            return DecimalFactory.getDecimal(number.doubleValue());
        }
        if (value instanceof Long)
        {
            Number number = (Number) value;
            return DecimalFactory.getDecimal(number.longValue());
        }
        if (value instanceof String)
        {
            try
            {
                return DecimalFactory.getDecimal((String) value);
            }
            catch (NumberFormatException e)
            {
                throw new ConversionException("Cannot convert " + value + " to " + type, e);
            }
        }
        throw new ConversionException("Cannot convert " + value + " to " + type);
    }


    @Override
    protected Class getDefaultType()
    {
        return Decimal.class;
    }

}
