/*
 * CloverETL Engine - Java based ETL application framework.
 * Copyright (c) Javlin, a.s. (info@cloveretl.com).  Use is subject to license terms.
 *
 * www.cloveretl.com
 */
package com.mulesoft.datamapper.transform.converter;

import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;

/**
 * @author jan.michalica (info@cloveretl.com)
 *         (c) Javlin, a.s. (www.cloveretl.com)
 * @created 24.7.2012
 */
public class EnumAwareConvertUtilsBean extends ConvertUtilsBean
{

    @SuppressWarnings("rawtypes")
    @Override
    public Converter lookup(Class sourceType, Class targetType)
    {
        /*
		 * check for conversion from/to enum
		 */
        if (isEnum(sourceType) || isEnum(targetType))
        {
            return lookup(Enum.class);
        }
        return super.lookup(sourceType, targetType);
    }

    private final boolean isEnum(Class<?> type)
    {
        return type != null && type.isEnum();
    }
}
