/*
 * CloverETL Engine - Java based ETL application framework.
 * Copyright (c) Javlin, a.s. (info@cloveretl.com).  Use is subject to license terms.
 *
 * www.cloveretl.com
 */
package com.mulesoft.datamapper.transform.converter;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.jetel.util.string.CloverString;

/**
 * Converter for enumerated types.
 *
 * @author jan.michalica (info@cloveretl.com)
 *         (c) Javlin, a.s. (www.cloveretl.com)
 * @created 24.7.2012
 */
public final class EnumConverter implements Converter
{

    @SuppressWarnings({"unchecked", "rawtypes"})
    @Override
    public Object convert(Class type, Object value)
    {

        if (type.isEnum() && value instanceof CharSequence)
        {
            try
            {
                return Enum.valueOf(type, ((CharSequence) value).toString());
            }
            catch (IllegalArgumentException e)
            {
                throw new ConversionException("Value '" + value + "' cannot be converted to enumerated constant of " + type.getName());
            }
        }
        if (value instanceof Enum<?>)
        {
            Enum<?> e = (Enum<?>) value;
            if (CloverString.class.equals(type))
            {
                return new CloverString(e.name());
            }
            else
            {
                return e.name();
            }
        }
        throw new ConversionException("Value '" + value + "' cannot be converted to a value of type " + type.getName());
    }
}
