/*
 * CloverETL Engine - Java based ETL application framework.
 * Copyright (c) Javlin, a.s. (info@cloveretl.com).  Use is subject to license terms.
 *
 * www.cloveretl.com
 */
package com.mulesoft.datamapper.transform.converter;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractConverter;

/**
 * @author jan.michalica (info@cloveretl.com)
 *         (c) Javlin, a.s. (www.cloveretl.com)
 * @created 24.7.2012
 */
@SuppressWarnings("rawtypes")
public class UriConverter extends AbstractConverter
{

    @Override
    protected Object convertToType(Class type, Object value) throws Throwable
    {

        if (value instanceof String)
        {
            try
            {
                return new URI((String) value);
            }
            catch (URISyntaxException e)
            {
                throw new ConversionException("Cannot create URI from " + value, e);
            }
        }
        if (value instanceof URL)
        {
            try
            {
                return new URI(value.toString());
            }
            catch (URISyntaxException e)
            {
                /*
				 * should not happen
				 */
                throw new ConversionException("Cannot create URI from " + value, e);
            }
        }
        throw new ConversionException("Cannot create URI from " + value);
    }

    @Override
    protected Class getDefaultType()
    {
        return URI.class;
    }

}
