/**
 *
 * (c) 2013 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import org.joda.time.DateTime;
import org.mule.api.el.ExpressionLanguageContext;

import java.util.Calendar;
import java.util.Date;

public class Calendar2DateFunction extends AbstractExpressionLanguageFunction
{
    @Override
    public Object call(Object[] params, ExpressionLanguageContext context)
    {
        if (params.length == 1)
        {
            if(params[0] == null)
            {
                return null;
            }

            if (isString(params[0]))
            {
                String dateString = (String) params[0];
                return calendarToDate(dateString);

            }
            else if(isCalendar(params[0]))
            {
                Calendar inputCalendar = (Calendar) params[0];
                return calendarToDate(inputCalendar);
            }
            else if(isDate(params[0]))
            {
                Date inputDate = (Date) params[0];
                return calendarToDate(inputDate);
            }
        }

        throw new IllegalArgumentException("Illegal call " + getSignatureFromParams("calendar2date", params) + " to calendar2date(Calendar calendar) ");

    }

    public static Date calendarToDate(String dateString)
    {
        DateTime dateTime = DateFunctionUtils.parseISO8610DateTime(dateString);
        return dateTime.toDate();
    }

    public static Date calendarToDate(Calendar calendar)
    {
        DateTime dateTime = new DateTime(calendar);
        return dateTime.toDate();
    }

    public static Date calendarToDate(Date date)
    {
        DateTime dateTime = new DateTime(date);
        return dateTime.toDate();
    }
}
