/**
 *
 * (c) 2013 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import org.joda.time.DateTime;
import org.mule.api.el.ExpressionLanguageContext;

import java.util.Calendar;
import java.util.Date;

public class Calendar2LongFunction extends AbstractExpressionLanguageFunction
{

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context)
    {
        if (params.length == 1)
        {
            if(params[0] == null){
                return null;
            }

            if (isString(params[0]) )
            {
                String dateString = (String) params[0];
                return calendarToLong(dateString);
            }
            else if (isCalendar(params[0]) )
            {
                Calendar calendar = (Calendar) params[0];
                return calendarToLong(calendar);
            }
            else if (isCalendar(params[0]) )
            {
                Date date = (Date) params[0];
                return calendarToLong(date);
            }
        }

        throw new IllegalArgumentException("Illegal call " + getSignatureFromParams("calendar2long", params) + " to calendar2long(Calendar calendar) ");
    }

    public static Long calendarToLong(String dateString)
    {
        DateTime dateTime = DateFunctionUtils.parseISO8610DateTime(dateString);
        return dateTime.getMillis();
    }

    public static Long calendarToLong(Calendar inputCalendar)
    {
        DateTime dateTime = new DateTime(inputCalendar);
        return dateTime.getMillis();
    }

    public static Long calendarToLong(Date inputDate)
    {
        return inputDate.getTime();
    }


}
