/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import org.joda.time.DateTime;
import org.mule.api.el.ExpressionLanguageContext;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class Calendar2NumFunction extends AbstractExpressionLanguageFunction
{

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context)
    {
        if (params.length == 2)
        {
            if(params[0] == null)
            {
                return null;
            }
            if(!isInteger(params[1]))
            {
                throw new IllegalArgumentException("Invalid call " + getSignatureFromParams("calendar2num", params) + " to calendar2num(Calendar calendar,Integer calendarUnit)");
            }
            final Integer calendarConstant = (Integer) params[1];
            if(isString(params[0]))
            {
                return calendarToNumber((String) params[0], calendarConstant);
            }
            else if(isCalendar(params[0]))
            {
                return calendarToNumber((Calendar) params[0], calendarConstant);
            }
        }
        throw new IllegalArgumentException("Invalid call " + getSignatureFromParams("calendar2num", params) + " to calendar2num(Calendar calendar,Integer calendarUnit)");
    }

    public static Integer calendarToNumber(String str_calendar, Integer calendarConstant)
    {
        DateTime dateTime = DateFunctionUtils.parseISO8610DateTime(str_calendar);
        return dateTime.toGregorianCalendar().get(calendarConstant);
    }

    public static Integer calendarToNumber(Calendar calendar, Integer calendarConstant)
    {
        return calendar.get(calendarConstant);
    }
}
