/**
 *
 * (c) 2013 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import org.joda.time.DateTime;
import org.mule.api.el.ExpressionLanguageContext;

import java.util.Calendar;
import java.util.Date;

public class Calendar2StrFunction extends AbstractExpressionLanguageFunction
{

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context)
    {
        if (params.length == 2)
        {
            if(params[0] == null){
                return null;
            }

            if(!isString(params[1]))
            {
                throw new IllegalArgumentException("Illegal call " + getSignatureFromParams("calendar2str", params) + " to calendar2str(Calendar calendar,String pattern) ");
            }

            if (isString(params[0]))
            {
                String dateString = (String) params[0];
                String outputPattern = (String) params[1];
                return calendarToStr(dateString, outputPattern);
            }
            else if(isCalendar(params[0]))
            {
                Calendar calendar = (Calendar) params[0];
                String outputPattern = (String) params[1];
                return calendarToStr(calendar,outputPattern);
            }
            else if(isDate(params[0]))
            {
                Date date = (Date) params[0];
                String outputPattern = (String) params[1];
                return calendarToStr(date,outputPattern);
            }
        }

        throw new IllegalArgumentException("Illegal call " + getSignatureFromParams("calendar2str", params) + " to calendar2str(Calendar calendar,String pattern) ");
    }

    public static String calendarToStr(String dateString, String outputPattern)
    {
        DateTime dateTime = DateFunctionUtils.parseISO8610DateTime(dateString);
        return dateTime.toString(DateFunctionUtils.getAbsolutePattern(outputPattern));
    }

    public static String calendarToStr(Calendar calendar, String outputPattern)
    {
        DateTime dateTime = new DateTime(calendar);
        return dateTime.toString(DateFunctionUtils.getAbsolutePattern(outputPattern));
    }

    public static String calendarToStr(Date date, String outputPattern)
    {
        DateTime dateTime = new DateTime(date);
        return dateTime.toString(DateFunctionUtils.getAbsolutePattern(outputPattern));
    }
}
