/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.mule.api.el.ExpressionLanguageContext;

import java.util.Date;
import java.util.TimeZone;

public class Date2CalendarFunction extends AbstractExpressionLanguageFunction
{


    @Override
    public Object call(Object[] params, ExpressionLanguageContext context)
    {

        if (params.length == 1)
        {

            if (isDate(params[0]))
            {
                if(params[0] == null){
                    return null;
                }
                Date date = (Date) params[0];
                return dateToCalendar(date, null);
            }
        }
        else
        {
            if (isDate(params[0]) && isString(params[1]))
            {
                if(params[0] == null){
                    return null;
                }
                Date date = (Date) params[0];
                return dateToCalendar(date, TimeZone.getTimeZone(String.valueOf(params[1])));
            }
            else if (isDate(params[0]) && isTimeZone(params[1]))
            {
                if(params[0] == null){
                    return null;
                }
                Date date = (Date) params[0];
                return dateToCalendar(date, (TimeZone) params[1]);
            }
        }

        throw new IllegalArgumentException("Illegal call " + getSignatureFromParams("date2calendar", params) + " date2calendar(Date date) or date2calendar(Date date, String timezone)");
    }

    public static String dateToCalendar(Date date, TimeZone timeZone)
    {
        if (date == null)
        {
            return null;
        }
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        fmt = fmt.withZone(DateTimeZone.forTimeZone(timeZone));
        return fmt.print(new DateTime(date));
    }
}
