/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import org.mule.api.el.ExpressionLanguageContext;

import java.util.Calendar;
import java.util.Date;

import org.jetel.ctl.data.DateFieldEnum;

public class Date2NumFunction extends AbstractExpressionLanguageFunction
{

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context)
    {
        if (params.length != 2 || !(isDate(params[0]) && params[1] instanceof DateFieldEnum))
        {
            throw new IllegalArgumentException("Invalid call " + getSignatureFromParams("date2num", params) + " date2num(Date date,DateFieldEnum unit)");
        }

        Date date = (Date) params[0];
        if (date == null)
        {
            return null;
        }
        DateFieldEnum timeUnit = (DateFieldEnum) params[1];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        switch (timeUnit)
        {
            case YEAR:
                return calendar.get(Calendar.YEAR);
            case MONTH:
                return calendar.get(Calendar.MONTH) + 1; //months should be numerated from 1, not 0.
            case WEEK:
                return calendar.get(Calendar.WEEK_OF_YEAR);
            case DAY:
                return calendar.get(Calendar.DAY_OF_MONTH);
            case HOUR:
                return calendar.get(Calendar.HOUR_OF_DAY);
            case MINUTE:
                return calendar.get(Calendar.MINUTE);
            case SECOND:
                return calendar.get(Calendar.SECOND);
            case MILLISEC:
                return calendar.get(Calendar.MILLISECOND);

        }

        return null;
    }
}
