/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import org.apache.commons.lang.time.DateFormatUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.mule.api.el.ExpressionLanguageContext;

import java.util.Date;
import java.util.TimeZone;

public class Date2StrFunction extends AbstractExpressionLanguageFunction
{

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context)
    {

        if (params.length == 2)
        {
            if (isDate(params[0]) && isString(params[1]))
            {
                if(params[0] == null){
                    return null;
                }
                return dateToString((Date) params[0], (String) params[1], null);
            }
        }
        else
        {
            if (isDate(params[0]) && isString(params[1]) && isTimeZone(params[2]))
            {
                if(params[0] == null){
                    return null;
                }
                return dateToString((Date) params[0], (String) params[1], (TimeZone) params[2]);
            }
        }


        throw new IllegalArgumentException("Illegal call " + getSignatureFromParams("date2str", params) + " to date2str(Date date, String pattern)  or date2str(Date date, String pattern, TimeZone timeZone)   ");
    }


    public static String dateToString(Date date, String parsePatterns, TimeZone timeZone)
    {
        if (date == null)
        {
            return null;
        }
        if (parsePatterns.startsWith(DateFunctionUtils.JODA))
        {
            DateTimeFormatter fmt = DateTimeFormat.forPattern(DateFunctionUtils.getAbsolutePattern(parsePatterns));
            fmt = fmt.withZone(DateTimeZone.forTimeZone(timeZone));
            return fmt.print(new DateTime(date.getTime()));
        }
        else
        {
            return DateFormatUtils.format(date, parsePatterns, timeZone);
        }

    }
}
