/**
 *
 * (c) 2013 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;


import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.processor.MessageProcessor;
import org.mule.client.DefaultLocalMuleClient;

import com.mulesoft.datamapper.mule.PreviewMuleContextAccessor;

import java.util.HashMap;
import java.util.Map;

public class FlowRefFunction extends AbstractExpressionLanguageFunction

{

    private MuleContext muleContextAccessor;

    public FlowRefFunction(MuleContext muleContextAccessor)
    {
        this.muleContextAccessor = muleContextAccessor;
    }

    @Override
    public Object call(Object[] objects, ExpressionLanguageContext expressionLanguageContext)
    {
        if (objects.length == 2 && isString(objects[0]))
        {
            return flowRef((String) objects[0], objects[1], new HashMap<String, Object>());
        }
        else if (objects.length == 3 && isString(objects[0]) && isMap(objects[2]))
        {
            return flowRef((String) objects[0], objects[1], (Map<String, Object>) objects[2]);
        }
        else
        {
            throw new IllegalArgumentException("Invalid call " + getSignatureFromParams("flowRef", objects) + " to flowRef(String flowName,Object payload) or flowRef(String flowName,Map<String,Object> outboundProperties)");
        }

    }


    public Object flowRef(String flowName, Object payload, Map<String, Object> outboundProperties)
    {

        if (muleContextAccessor.getRegistry().get(PreviewMuleContextAccessor.PREVIEW) != null)
        {
            return null;
        }
        final MuleMessage muleMessage = new DefaultMuleMessage(payload, outboundProperties, muleContextAccessor);
        final MessageProcessor referencedMessageProcessor = getReferencedMessageProcessor(flowName);
        final MuleEvent muleEvent = createMuleEvent(muleMessage, MessageExchangePattern.REQUEST_RESPONSE);
        try
        {
            final MuleEvent process = referencedMessageProcessor.process(muleEvent);
            return process.getMessage().getPayload();
        }
        catch (MuleException e)
        {
            throw new RuntimeException(e);
        }

    }


    protected MuleEvent createMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern)
    {
        return new DefaultMuleEvent(message, exchangePattern, new DefaultLocalMuleClient.MuleClientFlowConstruct(
                muleContextAccessor));
    }

    protected MessageProcessor getReferencedMessageProcessor(String name)
    {
        final MessageProcessor processor = ((MessageProcessor) muleContextAccessor.getRegistry().get(name));
        if (processor == null)
        {
            throw new RuntimeException("Flow Name '" + name + "' was not found");
        }
        return processor;
    }

}
