/**
 *
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.mule.PreviewMuleContextAccessor;
import org.mule.api.MuleContext;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;

import com.mulesoft.datamapper.exception.DataMapperRuntimeException;
import org.mule.transport.NullPayload;

public class InvokeTransformerFunction extends AbstractExpressionLanguageFunction
{

    private MuleContext muleContextAccessor;

    public InvokeTransformerFunction(MuleContext muleContextAccessor)
    {
        this.muleContextAccessor = muleContextAccessor;
    }

    @Override
    public Object call(Object[] params, ExpressionLanguageContext expressionLanguageContext)
    {
        if (PreviewMuleContextAccessor.isRunningOnPreview(muleContextAccessor))
        {
            return null;
        }
        if (params.length == 2)
        {

            if (isString(params[0]))
            {
                if(params[0] == null)
                {
                    return null;
                }
                String name = String.valueOf(params[0]);
                Transformer transformer = muleContextAccessor.getRegistry().lookupTransformer(name);
                if (transformer == null)
                {
                    throw new IllegalArgumentException("Invalid transformer name  '" + name + "'");
                }
                else
                {
                    try
                    {
                        Object transform = transformer.transform(params[1]);
                        return transform == NullPayload.getInstance() ? null : transform;
                    }
                    catch (TransformerException e)
                    {
                        throw new DataMapperRuntimeException(e);
                    }
                }
            }
            throw new IllegalArgumentException("Invalid call " + getSignatureFromParams("invokeTransformer", params) + " to invokeTransformer(String name , Object valueToTransform)");
        }
        else if (params.length == 3)
        {

            if (isString(params[0]) && isString(params[2]))
            {
                if(params[0] == null){
                    return null;
                }
                String name = String.valueOf(params[0]);
                Transformer transformer = muleContextAccessor.getRegistry().lookupTransformer(name);
                if (transformer == null)
                {
                    throw new IllegalArgumentException("Invalid transformer name  '" + name + "'");
                }
                else
                {
                    try
                    {
                        return transformer.transform(params[1], String.valueOf(params[2]));
                    }
                    catch (TransformerException e)
                    {
                        throw new DataMapperRuntimeException(e);
                    }
                }
            }
            throw new IllegalArgumentException("Invalid call " + getSignatureFromParams("invokeTransformer", params) + " to invokeTransformer(String name , Object valueToTransform, String encoding)");
        }

        throw new IllegalArgumentException("Invalid call " + getSignatureFromParams("invokeTransformer", params) + " to invokeTransformer(String name , Object valueToTransform) or invokeTransformer(String name , Object valueToTransform, String encoding)");
    }
}
