/**
 *
 * (c) 2013 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import org.apache.commons.lang.time.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.mule.api.el.ExpressionLanguageContext;

import java.util.Date;
import java.util.TimeZone;

public class Long2CalendarFunction extends AbstractExpressionLanguageFunction
{

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context)
    {

        if (params.length == 1)
        {
            if (isLong(params[0]))
            {
                if(params[0] == null){
                    return null;
                }
                Long milliseconds = (Long) params[0];
                return longToCalendar(milliseconds, DateUtils.UTC_TIME_ZONE);
            }
        }
        else if (params.length == 2)
        {
            if (isLong(params[0]) && isTimeZone(params[1]))
            {
                if(params[0] == null){
                    return null;
                }
                Long milliseconds = (Long) params[0];
                return longToCalendar(milliseconds, (TimeZone) params[1]);
            }
        }
        throw new IllegalArgumentException("Invalid call " + getSignatureFromParams("long2calendar", params) + " long2calendar(Long milliseconds) or long2calendar(Long milliseconds, TimeZone timeZone)");
    }

    public static String longToCalendar(Long milliseconds, TimeZone timeZone)
    {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        fmt = fmt.withZone(DateTimeZone.forTimeZone(timeZone));
        DateTime dateTime = new DateTime(new Date(milliseconds));
        return fmt.print(dateTime);
    }
}
