/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.transform.CloverTypesUtils;
import com.mulesoft.datamapper.transform.DataRecordContext;

import java.util.Map;

import org.jetel.data.DataRecord;
import org.jetel.data.DataRecordFactory;
import org.jetel.data.RecordKey;
import org.jetel.data.lookup.Lookup;
import org.jetel.data.lookup.LookupTable;
import org.jetel.exception.ComponentNotReadyException;
import org.jetel.metadata.DataFieldMetadata;
import org.jetel.metadata.DataRecordMetadata;

public class LookupAccessor
{

    private LookupTable lookupTable;
    private Lookup lookup;
    private DataRecordMetadata keyMetadata;
    private RecordKey recordKey;

    public LookupAccessor(LookupTable lookupTable)
    {
        this.lookupTable = lookupTable;
    }

    public Map<String, Object> get(Object[] args) throws ComponentNotReadyException
    {
        intLookup(args);
        final DataRecord input = DataRecordFactory.newRecord(keyMetadata);
        input.init();
        for (int i = 0; i < args.length; i++)
        {
            Object arg = args[i];
            input.getField(i).setValue(arg);
        }

        lookup.seek(input);
        final DataRecord next = lookup.hasNext() ? lookup.next() : null;
        return next != null ? new DataRecordContext(next) : null;
    }

    private void intLookup(Object[] args) throws ComponentNotReadyException
    {
        if (keyMetadata == null)
        {
            try
            {
                keyMetadata = lookupTable.getKeyMetadata();
                final DataRecordMetadata keyMetadata = lookupTable.getKeyMetadata();
                recordKey = new RecordKey(keyMetadata.getFieldNamesArray(), keyMetadata);
            }
            catch (UnsupportedOperationException e) //DBLookupTable does not support create
            {
                final DataRecordMetadata keyRecordMetadata = new DataRecordMetadata(lookupTable.getName() + "_metadata");
                final int[] keyFields = new int[args.length];
                for (int i = 0; i < args.length; i++)
                {
                    Class<?> aClass = args[i] != null ? args[i].getClass() : null;
                    final DataFieldMetadata field = new DataFieldMetadata("_field" + i, CloverTypesUtils.getFieldTypeFromJavaClass(aClass), "|");
                    keyRecordMetadata.addField(field);
                    keyFields[i] = i;

                }
                recordKey = new RecordKey(keyFields, keyRecordMetadata);
                keyMetadata = keyRecordMetadata;
            }
            recordKey.init();
            lookup = lookupTable.createLookup(recordKey);
        }

    }


}
