/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageFunction;

import com.mulesoft.datamapper.exception.DataMapperRuntimeException;
import com.mulesoft.datamapper.transform.LookupTableAware;

import org.jetel.data.lookup.LookupTable;
import org.jetel.exception.ComponentNotReadyException;

public class LookupFunction implements ExpressionLanguageFunction
{

    private LookupTableAware graph;

    public LookupFunction(LookupTableAware graph)
    {
        this.graph = graph;
    }

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context)
    {
        if (params.length != 1)
        {
            throw new IllegalArgumentException("Missing lookup table parameter or lookup table name parameter");
        }
        Object param = params[0];
        LookupTable lookupTable = null;
        if (param instanceof String)
        {
            lookupTable = graph.getLookupTable(String.valueOf(param));
        }
        else if (param instanceof LookupTable)
        {
            lookupTable = (LookupTable) param;
        }
        if (lookupTable == null)
        {
            throw new IllegalArgumentException("Parameter must be either a String or a LookupTable.");
        }

        if (!lookupTable.isInitialized())
        {
            try
            {
                lookupTable.init();
            }
            catch (ComponentNotReadyException e)
            {
                throw new DataMapperRuntimeException(e);
            }
        }

        return new LookupAccessor(lookupTable);
    }
}
