/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import org.mule.api.el.ExpressionLanguageContext;

import org.jetel.data.Defaults;
import org.jetel.data.primitive.StringFormat;

public class Str2BoolFunction extends AbstractExpressionLanguageFunction
{

    public static StringFormat trueFormat = StringFormat.create("T|TRUE|YES|Y||t|true|1|yes|y");

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context)
    {

        if (params.length == 1 && isString(params[0]))
        {
            String param = (String) params[0];
            if (param != null && trueFormat.matches(param))
            {
                return Boolean.TRUE;
            }
            else
            {
                return Boolean.FALSE;
            }
        }

        throw new IllegalArgumentException("Invalid call " + getSignatureFromParams("str2bool", params) + " to str2bool(String booleanString)");
    }
}
