/**
 *
 * (c) 2013 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import org.apache.commons.lang.time.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.mule.api.el.ExpressionLanguageContext;

import java.util.Date;
import java.util.TimeZone;

public class Str2CalendarFunction extends AbstractExpressionLanguageFunction
{

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context)
    {


        if (params.length == 2)
        {
            if (isString(params[0]) && isString(params[1]))
            {
                if(params[0] == null){
                    return null;
                }
                String dateString = (String) params[0];
                String datePattern = (String) params[1];
                return stringToCalendar(dateString, datePattern, DateUtils.UTC_TIME_ZONE);
            }
        }
        else if (params.length == 3)
        {
            if (isString(params[0]) && isString(params[1]) && isTimeZone(params[2]))
            {
                if(params[0] == null){
                    return null;
                }
                String dateString = (String) params[0];
                String datePattern = (String) params[1];
                return stringToCalendar(dateString, datePattern, (TimeZone) params[2]);
            }
        }

        throw new IllegalArgumentException("Illegal call " + getSignatureFromParams("str2calendar", params) + " to str2calendar(String dateString,String parsePattern) or str2calendar(String dateString,String parsePattern, TimeZone timeZone)");
    }

    public static String stringToCalendar(String dateString, String datePattern, TimeZone timeZone)
    {
        if (dateString == null)
        {
            return null;
        }
        Date date = new Str2DateFunction().parseDate(dateString, datePattern, timeZone);
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        fmt = fmt.withZone(DateTimeZone.forTimeZone(timeZone));
        return fmt.print(new DateTime(date.getTime()));
    }
}
