/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.mule.api.el.ExpressionLanguageContext;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Str2DateFunction extends AbstractExpressionLanguageFunction
{

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context)
    {
        if (params.length == 2)
        {
            if (isString(params[0]) && isString(params[1]))
            {
                if(params[0] == null){
                    return null;
                }
                String dateString = (String) params[0];
                String parsePatterns = (String) params[1];
                return parseDate(dateString, parsePatterns, TimeZone.getDefault());
            }
        }
        else if (params.length == 3)
        {
            if (isString(params[0]) && isString(params[1]) && isTimeZone(params[2]))
            {
                if(params[0] == null){
                    return null;
                }
                String dateString = (String) params[0];
                String parsePatterns = (String) params[1];
                return parseDate(dateString, parsePatterns, (TimeZone) params[2]);
            }
        }
        throw new IllegalArgumentException("Illegal call " + getSignatureFromParams("str2date", params) + " to str2date(String dateString, String parsePattern) or str2date(String dateString, String parsePattern , TimeZone timeZone)");
    }


    public Date parseDate(String dateString, String parsePatterns, TimeZone timeZone)
    {
        if (dateString == null)
        {
            return null;
        }

        if (parsePatterns.startsWith(DateFunctionUtils.JODA))
        {
            DateTimeFormatter fmt = DateTimeFormat.forPattern(DateFunctionUtils.getAbsolutePattern(parsePatterns));
            fmt = fmt.withZone(DateTimeZone.forTimeZone(timeZone));
            return fmt.parseDateTime(dateString).toDate();
        }
        else
        {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(parsePatterns);
            try
            {
                simpleDateFormat.setTimeZone(timeZone);
                return simpleDateFormat.parse(dateString);
            }
            catch (ParseException e)
            {
                throw new RuntimeException(e);
            }
        }
    }
}
