/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.transform.function;

import org.mule.api.el.ExpressionLanguageContext;

public class Str2DoubleFunction extends AbstractExpressionLanguageFunction
{

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context)
    {
        if (params.length == 1 && isString(params[0]))
        {
            if (params[0] == null)
            {
                return null;
            }
            return Double.parseDouble((String) params[0]);
        }

        throw new IllegalArgumentException("Invalid call " + getSignatureFromParams("str2double", params) + " to str2double(String num)");
    }

}
