/**
 *
 * (c) 2013 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.module.datamapper.api;

import com.mulesoft.mule.module.datamapper.clover.CloverEngineConfig;
import com.mulesoft.mule.module.datamapper.clover.SimpleCloverGraphExecutorFactoryImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineManager;

import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetel.component.fileoperation.pool.ConnectionPool;

public class DataMapperHelper
{

    private Log logger = LogFactory.getLog(DataMapperHelper.class);

    public Object execute(InputStream mappingFile, Object payload, Map<String, Object> arguments) throws Exception
    {
        GraphExecutorFactory executorFactory = null;
        try
        {
            executorFactory = createGraphExecutorFactory();
            executorFactory.init();
            GraphExecutor graphExecutor = executorFactory.createGraphExecutor(mappingFile);
            return graphExecutor.execute(payload, arguments).getPayload();
        }
        finally
        {
            if (executorFactory != null)
            {
                executorFactory.dispose();
            }
            try
            {
                deleteLoggingThreads();
                ConnectionPool.getInstance().close();
            }
            catch (Throwable t)
            {
                logger.error("Un expected error", t);
            }
        }
    }


    private void deleteLoggingThreads()
    {
        String[] threadsToDelete = {"Mule.log.clogging.ref.handler", "Mule.log.slf4j.ref.handler"};

        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Thread[] threadArray = threadSet.toArray(new Thread[threadSet.size()]);
        for (String threadToDelete : threadsToDelete)
        {
            for (Thread t : threadArray)
            {
                if (threadToDelete.equals(t.getName()))
                {
                    try
                    {
                        t.interrupt();
                    }
                    catch (SecurityException e)
                    {
                        // ignore
                    }
                }
            }
        }
    }

    protected GraphExecutorFactory createGraphExecutorFactory()
    {
        return new SimpleCloverGraphExecutorFactoryImpl(UUID.randomUUID().toString(), new CloverEngineManager(CloverEngineConfig.createDefault(), new ConcurrentHashMap<String, CloverEngineImpl>()));
    }
}
