/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.api;

import com.mulesoft.mule.module.datamapper.api.exception.DataMapperExecutionException;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;

/**
 * GraphExecutor provides an API for mule to execute a transformation graph.
 */
public interface GraphExecutor
{

    TransformationResult execute(Object payload, Map<String, Object> inputArguments) throws DataMapperExecutionException;

    Object executeStreaming(Object payload, int pipeSize,
                            Map<String, Object> inputArguments, OutputArgumentHandler outputArgumentHandler) throws DataMapperExecutionException;

    String getOutputContentType();


    String getOutputEncoding();
}
