/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.api;

import com.mulesoft.mule.module.datamapper.api.exception.DataMapperExecutionException;
import com.mulesoft.mule.module.datamapper.clover.MappingFormat;

import java.util.Map;

import org.jetel.graph.TransformationGraph;


public interface TransformationEngine<T>
{


    TransformationResult execute(T graph, Map<String, Object> inputArguments) throws DataMapperExecutionException;

    void executeLater(T graph, Map<String, Object> inputArguments, FutureCallback<TransformationResult> callback) throws DataMapperExecutionException;

    void dispose();

    MappingFormat getOutputType(T graph);

    String getOutputEncoding(T graph);

}
