package com.mulesoft.mule.module.datamapper.boot;

import com.mulesource.licm.EnterpriseLicenseKey;
import com.mulesource.licm.LicenseKeyException;
import com.mulesource.licm.LicenseManagementFactory;
import com.mulesource.licm.LicenseManager;
import com.mulesource.licm.feature.Feature;
import com.mulesource.licm.feature.FeatureValidator;

import de.schlichtherle.license.LicenseContentException;

import org.mule.module.reboot.EEMuleContainerBootstrap;

public class DataMapperLicenseCheck
{

    /**
     *
     */
    private DataMapperLicenseCheck()
    {
    }


    private static EnterpriseLicenseKey loadLicenseKey() throws LicenseKeyException
    {
        LicenseManager licenseManager = LicenseManagementFactory.getInstance().createLicenseManager(LicenseManagementFactory.MULE_EE);
        return licenseManager.validate(LicenseManagementFactory.MULE_EE);
    }


    private static void checkSapFeature(EnterpriseLicenseKey key) throws LicenseContentException
    {
        Feature sap = new Feature("datamapper", "MuleSoft DataMapper");
        new FeatureValidator(sap).validate(key);
    }


    public static void checkDMEntitlement() throws LicenseContentException, LicenseKeyException
    {
        if (!EEMuleContainerBootstrap.isEval())
        {
            EnterpriseLicenseKey key = loadLicenseKey();
            checkSapFeature(key);
        }

    }
}