/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.clover;

import com.mulesoft.mule.module.datamapper.api.GraphExecutor;
import com.mulesoft.mule.module.datamapper.api.GraphExecutorFactory;
import com.mulesoft.mule.module.datamapper.api.GraphProvider;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.CloverGraphFactory;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineManager;
import com.mulesoft.mule.module.datamapper.impl.DefaultGraphExecutor;

import java.io.InputStream;

import org.jetel.graph.TransformationGraph;
import org.jetel.graph.runtime.ExecutionType;

public abstract class AbstractCloverGraphExecutorFactory implements GraphExecutorFactory
{


    private CloverEngineManager cloverEngineManager;


    protected AbstractCloverGraphExecutorFactory(CloverEngineManager cloverEngineManager)
    {
        this.cloverEngineManager = cloverEngineManager;
    }

    @Override
    public void init()
    {
    }

    @Override
    public GraphExecutor createGraphExecutor(String transformationGraphPath) throws DataMapperCreationException
    {
        final GraphProvider<TransformationGraph> graphProvider = createGraphProvider(createGraphFactory(transformationGraphPath, ExecutionType.SINGLE_THREAD_EXECUTION));
        final GraphProvider<TransformationGraph> asyncGraphProvider = createGraphProvider(createGraphFactory(transformationGraphPath, ExecutionType.MULTI_THREAD_EXECUTION));
        return DefaultGraphExecutor.createGraphExecutor(graphProvider, asyncGraphProvider, getCloverEngine());
    }

    protected abstract CloverEngineImpl getCloverEngine();

    @Override
    public GraphExecutor createGraphExecutor(InputStream transformationGraphPath) throws DataMapperCreationException
    {

        final GraphProvider<TransformationGraph> graphProvider = createGraphProvider(createGraphFactory(transformationGraphPath, ExecutionType.SINGLE_THREAD_EXECUTION));
        final GraphProvider<TransformationGraph> asyncGraphProvider = createGraphProvider(createGraphFactory(transformationGraphPath, ExecutionType.MULTI_THREAD_EXECUTION));
        return DefaultGraphExecutor.createGraphExecutor(graphProvider, asyncGraphProvider, getCloverEngine());
    }

    protected abstract GraphProvider<TransformationGraph> createGraphProvider(CloverGraphFactory graphFactory) throws DataMapperCreationException;


    public CloverEngineManager getCloverEngineManager()
    {
        return cloverEngineManager;
    }

    protected abstract CloverGraphFactory createGraphFactory(String transformationGraphPath, ExecutionType executionType);

    protected abstract CloverGraphFactory createGraphFactory(InputStream inputStream, ExecutionType executionType);
}
