/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.clover;

import org.mule.util.FileUtils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;

/**
 * Configuration properties required by the CloverEngine
 */
public class CloverEngineConfig
{

    public static final String CLOVER_PLUGINS = "clover-plugins";
    public static final String PATH_SEPARATOR = ";";
    private String cloverPluginDirPath;


    public CloverEngineConfig()
    {

    }

    public String getCloverPluginDirPath()
    {
        return cloverPluginDirPath;
    }


    public void setCloverPluginDirPath(String cloverPluginDirPath)
    {
        this.cloverPluginDirPath = cloverPluginDirPath;
    }

    public static CloverEngineConfig createDefault()
    {
        CloverEngineConfig cloverEngineConfig = new CloverEngineConfig();
        final ClassLoader cl = cloverEngineConfig.getClass().getClassLoader();
        Enumeration<URL> resource = null;
        try
        {
            resource = cl.getResources(CLOVER_PLUGINS);
        }
        catch (IOException e)
        {

        }
        if (resource == null || !resource.hasMoreElements())
        {
            throw new RuntimeException("Data Mapper runtime is not installed on the mule runtime.");
        }
        try
        {
            String cloverPluginsPath = null;
            while (resource.hasMoreElements())
            {
                URL plugin_url = resource.nextElement();
                String pluginPath = URLDecoder.decode(plugin_url.getFile(), FileUtils.DEFAULT_ENCODING);
                if (cloverPluginsPath == null)
                {
                    cloverPluginsPath = pluginPath;
                }
                else
                {
                    cloverPluginsPath = cloverPluginsPath + PATH_SEPARATOR + pluginPath;
                }
            }
            cloverEngineConfig.setCloverPluginDirPath(cloverPluginsPath);
        }
        catch (UnsupportedEncodingException e)
        {
            //UTF-8 should be supported
        }

        return cloverEngineConfig;
    }
}
