/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.clover;

import org.mule.api.MuleContext;

import com.mulesoft.mule.module.datamapper.api.GraphProvider;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.CloverGraphFactory;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineManager;
import com.mulesoft.mule.module.datamapper.clover.impl.GraphRuntimeContextFactoryImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.graphfactory.DocumentCloverGraphFactoryImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.graphfactory.InputStreamCloverGraphFactoryImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.graphprovider.CloverGraphPoolFactory;
import com.mulesoft.mule.module.datamapper.clover.impl.graphprovider.PoolGraphProvider;
import com.mulesoft.mule.module.datamapper.util.DataMapperUtils;

import java.io.InputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetel.graph.TransformationGraph;
import org.jetel.graph.runtime.ExecutionType;

public class CloverGraphExecutorFactory extends AbstractCloverGraphExecutorFactory
{


    private MuleContext muleContext;
    private static Log logger = LogFactory.getLog(CloverGraphExecutorFactory.class);
    private int initialPoolSize;

    public CloverGraphExecutorFactory(MuleContext muleContext, CloverEngineManager cloverEngineManager, int initialPoolSize)
    {
        super(cloverEngineManager);
        this.muleContext = muleContext;
        this.initialPoolSize = initialPoolSize;
    }


    @Override
    protected CloverEngineImpl getCloverEngine()
    {
        return getCloverEngineManager().getCloverEngine(muleContext);
    }

    @Override
    protected GraphProvider<TransformationGraph> createGraphProvider(CloverGraphFactory graphFactory) throws DataMapperCreationException
    {
        final CloverGraphPoolFactory graphPoolFactory = new CloverGraphPoolFactory(graphFactory);
        PoolGraphProvider graphProvider = PoolGraphProvider.createGraphProvider(graphPoolFactory);
        graphProvider.initialize(initialPoolSize);
        return graphProvider;
    }

    @Override
    public void dispose()
    {
        getCloverEngineManager().dispose(muleContext);
    }


    @Override
    protected CloverGraphFactory createGraphFactory(String transformationGraphPath, ExecutionType executionType)
    {
        return new DocumentCloverGraphFactoryImpl(new GraphRuntimeContextFactoryImpl(executionType, muleContext.getExecutionClassLoader()), muleContext, DataMapperUtils.parseDocument(muleContext, transformationGraphPath));
    }

    @Override
    protected CloverGraphFactory createGraphFactory(InputStream inputStream, ExecutionType executionType)
    {
        return new InputStreamCloverGraphFactoryImpl(new GraphRuntimeContextFactoryImpl(executionType, muleContext.getExecutionClassLoader()), inputStream);
    }


}
